/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRunner
implements Runnable {
    public static final int PROCESS_RUNNING = -1;
    public static final int PROCESS_ABORTED = -2;
    private static final Logger log = LoggerFactory.getLogger((Class)ProcessRunner.class);
    private static final int POLL_OUTPUT_DELAY = 100;
    private final String cmdLine;
    private final InputStream stdin;
    private final OutputStream stdout;
    private final OutputStream stderr;
    private final Object lock = new Object();
    private boolean running = true;
    private int rc = -1;

    public ProcessRunner(String cmdLine, InputStream stdin, OutputStream stdout, OutputStream stderr) {
        this.cmdLine = cmdLine;
        this.stdin = stdin;
        this.stdout = stdout == null ? System.out : stdout;
        this.stderr = stderr == null ? System.err : stderr;
    }

    public ProcessRunner(String cmdLine) {
        this(cmdLine, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(long waitTime) {
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.start();
        if (waitTime < 0L) return;
        Object object = this.lock;
        synchronized (object) {
            while (this.running) {
                try {
                    this.lock.wait(waitTime);
                    if (!this.running) continue;
                    t.interrupt();
                    waitTime = 0L;
                }
                catch (InterruptedException ie) {}
            }
            return;
        }
    }

    public int getReturnCode() {
        return this.rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        Object e22222222;
        InputStream procOut = null;
        InputStream procErr = null;
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(this.cmdLine);
            procOut = p.getInputStream();
            procErr = p.getErrorStream();
            this.writeStdIn(p, this.stdin);
            while (p != null) {
                Thread.sleep(100L);
                this.spoolAvailable(procOut, this.stdout);
                this.spoolAvailable(procErr, this.stderr);
                try {
                    this.rc = p.exitValue();
                    p = null;
                }
                catch (IllegalThreadStateException e22222222) {}
            }
            log.info("run: Process ended with rc={}", (Object)new Integer(this.rc));
            this.tryClose(procOut);
            this.tryClose(procErr);
            e22222222 = this.lock;
        }
        catch (IOException ioe2222222222) {
            log.info("run: IO problem during execution: {}", (Object)ioe2222222222.toString());
            this.tryClose(procOut);
            this.tryClose(procErr);
            Object ioe2222222222 = this.lock;
            synchronized (ioe2222222222) {
                this.lock.notifyAll();
                this.running = false;
            }
        }
        catch (InterruptedException ie) {
            if (p != null) {
                p.destroy();
                try {
                    this.rc = p.exitValue();
                }
                catch (IllegalThreadStateException itse) {
                    log.info("run: Exit value of destroyed process unavailable");
                }
                p = null;
            }
            this.tryClose(procOut);
            this.tryClose(procErr);
            Object object = this.lock;
            {
                catch (Throwable throwable) {
                    this.tryClose(procOut);
                    this.tryClose(procErr);
                    Object object2 = this.lock;
                    synchronized (object2) {
                        this.lock.notifyAll();
                        this.running = false;
                    }
                    throw throwable;
                }
            }
            synchronized (object) {
                this.lock.notifyAll();
                this.running = false;
            }
        }
        synchronized (e22222222) {
            this.lock.notifyAll();
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStdIn(Process proc, InputStream stdin) throws IOException {
        if (stdin != null) {
            int bufLen = 1024;
            byte[] b = new byte[1024];
            OutputStream procIn = null;
            try {
                int numRead;
                procIn = proc.getOutputStream();
                while ((numRead = stdin.read(b)) > 0) {
                    procIn.write(b, 0, numRead);
                }
            }
            finally {
                this.tryClose(procIn);
            }
        }
    }

    private void spoolAvailable(InputStream source, OutputStream sink) throws IOException {
        int num;
        int bufLen = 1024;
        byte[] buf = new byte[1024];
        for (int avail = source.available(); avail > 0; avail -= num) {
            num = avail > 1024 ? 1024 : avail;
            num = source.read(buf, 0, num);
            sink.write(buf, 0, num);
        }
    }

    private void tryClose(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void tryClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

