/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.util;

import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.util.LineInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class FileInputSource
extends VaultInputSource {
    private final File file;
    private byte[] lineSeparator;

    public FileInputSource(File file) {
        super(file.getPath());
        this.file = file;
    }

    public void setLineSeparator(byte[] lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public InputStream getByteStream() {
        try {
            if (this.lineSeparator != null) {
                return new LineInputStream(new FileInputStream(this.file), this.lineSeparator);
            }
            return FileUtils.openInputStream((File)this.file);
        }
        catch (IOException e) {
            return null;
        }
    }

    public long getContentLength() {
        return this.file.length();
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public void discard() {
        this.file.delete();
        this.file.deleteOnExit();
    }
}

