/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.io;

import com.day.jcr.vault.fs.config.MetaInf;
import com.day.jcr.vault.fs.impl.JrVltArchive;
import com.day.jcr.vault.fs.impl.JrVltMetaInfAdapter;
import com.day.jcr.vault.fs.impl.JrVltVaultInputSourceAdapter;
import com.day.jcr.vault.fs.io.Archive;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.io.Archive;

public class JrVltArchiveAdapter
implements Archive {
    private final org.apache.jackrabbit.vault.fs.io.Archive archive;

    protected JrVltArchiveAdapter(org.apache.jackrabbit.vault.fs.io.Archive archive) {
        this.archive = archive;
    }

    public org.apache.jackrabbit.vault.fs.io.Archive unwrap() {
        return this.archive;
    }

    public static Archive create(org.apache.jackrabbit.vault.fs.io.Archive archive) {
        if (archive instanceof JrVltArchive) {
            return ((JrVltArchive)archive).unwrap();
        }
        return archive == null ? null : new JrVltArchiveAdapter(archive);
    }

    public void open(boolean strict) throws IOException {
        this.archive.open(strict);
    }

    public InputStream openInputStream(Archive.Entry entry) throws IOException {
        return this.archive.openInputStream(JrVltArchive.Entry.create((Archive.Entry)entry));
    }

    public com.day.jcr.vault.fs.api.VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
        return JrVltVaultInputSourceAdapter.create((VaultInputSource)this.archive.getInputSource(JrVltArchive.Entry.create((Archive.Entry)entry)));
    }

    public Archive.Entry getJcrRoot() throws IOException {
        return EntryAdapter.create(this.archive.getJcrRoot());
    }

    public Archive.Entry getRoot() throws IOException {
        return EntryAdapter.create(this.archive.getRoot());
    }

    public MetaInf getMetaInf() {
        return JrVltMetaInfAdapter.create((org.apache.jackrabbit.vault.fs.config.MetaInf)this.archive.getMetaInf());
    }

    public Archive.Entry getEntry(String path) throws IOException {
        return EntryAdapter.create(this.archive.getEntry(path));
    }

    public Archive getSubArchive(String root, boolean asJcrRoot) throws IOException {
        return JrVltArchiveAdapter.create(this.archive.getSubArchive(root, asJcrRoot));
    }

    public void close() {
        this.archive.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EntryAdapter
    implements Archive.Entry {
        private final Archive.Entry entry;

        private EntryAdapter(Archive.Entry entry) {
            this.entry = entry;
        }

        public Archive.Entry unwrap() {
            return this.entry;
        }

        public static Archive.Entry create(Archive.Entry entry) {
            if (entry instanceof JrVltArchive.Entry) {
                return ((JrVltArchive.Entry)entry).unwrap();
            }
            return new EntryAdapter(entry);
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        @Override
        public Collection<? extends Archive.Entry> getChildren() {
            Collection<? extends Archive.Entry> entries = this.entry.getChildren();
            ArrayList<Archive.Entry> ret = new ArrayList<Archive.Entry>(entries.size());
            for (Archive.Entry entry : entries) {
                ret.add(EntryAdapter.create(entry));
            }
            return ret;
        }

        @Override
        public Archive.Entry getChild(String name) {
            return EntryAdapter.create(this.entry.getChild(name));
        }
    }
}

