/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.config;

import com.day.jcr.vault.fs.config.ConfigurationException;
import com.day.jcr.vault.fs.config.CredentialsConfig;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleCredentialsConfig
extends CredentialsConfig {
    private final SimpleCredentials creds;
    public static final String ELEM_USER = "user";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_PASSWORD = "password";

    public SimpleCredentialsConfig(SimpleCredentials creds) {
        super("simple");
        this.creds = creds;
    }

    public Credentials getCredentials() {
        return this.creds;
    }

    public static SimpleCredentialsConfig load(Element elem) throws ConfigurationException {
        assert (elem.getNodeName().equals("credentials"));
        NodeList nl = elem.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(ELEM_USER)) continue;
            Element e = (Element)child;
            String name = e.getAttribute(ATTR_NAME);
            String pass = e.getAttribute(ATTR_PASSWORD);
            return new SimpleCredentialsConfig(new SimpleCredentials(name, pass == null ? new char[]{} : pass.toCharArray()));
        }
        throw new ConfigurationException("mandatory element <user> missing.");
    }

    public void writeInner(ContentHandler handler) throws SAXException {
        if (this.creds != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", ATTR_NAME, "", "CDATA", this.creds.getUserID());
            attrs.addAttribute("", ATTR_PASSWORD, "", "CDATA", new String(this.creds.getPassword()));
            handler.startElement("", ELEM_USER, "", attrs);
            handler.endElement("", ELEM_USER, "");
        }
    }
}

