/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs;

import com.day.jcr.vault.fs.api.AccessType;
import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.ArtifactType;
import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.api.ExportArtifact;
import com.day.jcr.vault.fs.api.SerializationType;
import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.fs.io.Serializer;
import com.day.jcr.vault.util.TempFileInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.io.output.DeferredFileOutputStream;

public class SerializerArtifact
implements ExportArtifact {
    private final Serializer serializer;
    private final long lastModified;

    public SerializerArtifact(Artifact parent, String name, String ext, ArtifactType type, Serializer serializer, long lastModified) {
        throw new UnsupportedOperationException("No longer supported. use the org.apache.jackrabbit.vault counterpart.");
    }

    public AccessType getPreferredAccess() {
        return AccessType.SPOOL;
    }

    public SerializationType getSerializationType() {
        return this.serializer.getType();
    }

    public void spool(OutputStream out) throws IOException, RepositoryException {
        this.serializer.writeContent(out);
    }

    public InputStream getInputStream() throws IOException, RepositoryException {
        DeferredFileOutputStream out = new DeferredFileOutputStream(8192, "vlttmp", ".tmp", null);
        this.spool((OutputStream)out);
        out.close();
        if (out.isInMemory()) {
            return new ByteArrayInputStream(out.getData());
        }
        return new TempFileInputStream(out.getFile());
    }

    public VaultInputSource getInputSource() throws IOException, RepositoryException {
        long size;
        InputStream in;
        DeferredFileOutputStream out = new DeferredFileOutputStream(8192, "vlttmp", ".tmp", null);
        this.spool((OutputStream)out);
        out.close();
        if (out.isInMemory()) {
            in = new ByteArrayInputStream(out.getData());
            size = out.getData().length;
        } else {
            in = new TempFileInputStream(out.getFile());
            size = out.getFile().length();
        }
        return new VaultInputSource(){

            public String getSystemId() {
                return SerializerArtifact.this.getRelativePath();
            }

            public InputStream getByteStream() {
                return in;
            }

            public long getContentLength() {
                return size;
            }

            public long getLastModified() {
                return SerializerArtifact.this.lastModified;
            }
        };
    }

    public String getContentType() {
        throw new UnsupportedOperationException("No longer supported. use the org.apache.jackrabbit.vault counterpart.");
    }

    public long getContentLength() {
        return -1L;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getPlatformPath() {
        return null;
    }

    public String getExtension() {
        return null;
    }

    public String getRelativePath() {
        return null;
    }

    public ArtifactType getType() {
        return null;
    }

    public void dump(DumpContext ctx, boolean isLast) {
    }
}

