/*
 * Decompiled with CFR 0.152.
 */
package com.day.io.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static final Logger log = LoggerFactory.getLogger((Class)StreamUtils.class);

    public static String convertStreamToString(InputStream in) throws IOException {
        log.debug("Starting convertStreamToString (in : " + in + " , " + ")");
        return new String(StreamUtils.readBytesFromStream(in));
    }

    public static byte[] readBytesFromStream(InputStream in) throws IOException {
        log.debug("Starting readBytesFromStream (in : " + in + " , " + ")");
        int bytesread = 0;
        byte[] readBuffer = new byte[4096];
        byte[] content = new byte[]{};
        while ((bytesread = in.read(readBuffer, 0, readBuffer.length)) > 0) {
            content = StreamUtils.append(content, readBuffer, bytesread);
        }
        in.close();
        return content;
    }

    public static void pipeInputToOutput(InputStream in, OutputStream out) throws IOException {
        byte[] readBuffer = new byte[4096];
        int bytesread = 0;
        while ((bytesread = in.read(readBuffer, 0, readBuffer.length)) > 0) {
            out.write(readBuffer, 0, bytesread);
        }
        in.close();
        out.flush();
        out.close();
    }

    public static boolean areStreamsIdentical(InputStream first, InputStream second) throws IOException {
        int readFromFirst;
        boolean streamsAreIdentical = true;
        do {
            int readFromSecond;
            if ((readFromFirst = first.read()) == (readFromSecond = second.read())) continue;
            streamsAreIdentical = false;
            break;
        } while (readFromFirst != -1);
        first.close();
        second.close();
        return streamsAreIdentical;
    }

    public static String readStringFromReader(Reader in) throws IOException {
        int bytesread = 0;
        char[] readBuffer = new char[4096];
        char[] content = new char[]{};
        while ((bytesread = in.read(readBuffer, 0, readBuffer.length)) > 0) {
            content = StreamUtils.append(content, readBuffer, bytesread);
        }
        in.close();
        return new String(content);
    }

    public static String readStringFromReaderDontClose(Reader in) throws IOException {
        int bytesread = 0;
        char[] readBuffer = new char[4096];
        char[] content = new char[]{};
        while ((bytesread = in.read(readBuffer, 0, readBuffer.length)) > 0) {
            content = StreamUtils.append(content, readBuffer, bytesread);
        }
        return new String(content);
    }

    public static InputStream convertStringToStream(String astring) {
        log.debug("Starting convertStringToStream (astring : " + astring + " , " + ")");
        return new ByteArrayInputStream(astring.getBytes());
    }

    public static byte[] append(byte[] source, byte[] addition, int length) {
        log.debug("Starting append (source : " + source + " , " + "addition : " + addition + " , " + "length : " + length + " , " + ")");
        byte[] dest = new byte[source.length + length];
        System.arraycopy(source, 0, dest, 0, source.length);
        System.arraycopy(addition, 0, dest, source.length, length);
        return dest;
    }

    public static char[] append(char[] source, char[] addition, int length) {
        log.debug("Starting append (source : " + source + " , " + "addition : " + addition + " , " + "length : " + length + " , " + ")");
        char[] dest = new char[source.length + length];
        System.arraycopy(source, 0, dest, 0, source.length);
        System.arraycopy(addition, 0, dest, source.length, length);
        return dest;
    }

    public static String loadFromURL(String urlReference) throws IOException {
        int c;
        URL pageURL = new URL(urlReference);
        URLConnection openConnection = pageURL.openConnection();
        openConnection.connect();
        InputStream input = openConnection.getInputStream();
        StringBuffer buf = new StringBuffer();
        while ((c = input.read()) >= 0) {
            buf.append((char)c);
        }
        input.close();
        return buf.toString();
    }
}

