/*
 * Decompiled with CFR 0.152.
 */
package com.day.io.file;

import com.day.io.file.StreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger((Class)FileUtils.class);

    private static byte[] readFirstXBytesFromFile(File fileName, int iNoOfBytes) throws IOException {
        log.debug("Starting readFirstXBytesFromFile (fileName : " + fileName + " , " + "iNoOfBytes : " + iNoOfBytes + " , " + ")");
        byte[] buffer = new byte[iNoOfBytes];
        FileInputStream in = new FileInputStream(fileName);
        in.read(buffer);
        in.close();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytesToFile(byte[] data, File fOutput) throws IOException {
        log.debug("Starting writeBytesToFile (data : " + data + " , " + "fOutput : " + fOutput + " , " + ")");
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(fOutput));
            out.write(data);
            ((BufferedOutputStream)out).flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static File getFileFromClassesRoot(String fileName) throws FileNotFoundException {
        log.debug("Starting getFileFromClassesRoot (fileName : " + fileName + " , " + ")");
        return FileUtils.getFileFromClassesRoot(fileName, FileUtils.class);
    }

    public static File getFileFromClassesRoot(String fileName, Class relativeTo) throws FileNotFoundException {
        log.debug("Starting getFileFromClassesRoot (fileName : " + fileName + " , " + "relativeTo : " + relativeTo + " , " + ")");
        URL u = relativeTo.getResource("/resources/" + fileName);
        if (u == null || u.getFile() == null) {
            throw new FileNotFoundException("File " + fileName + " not found in the root of the classes directory " + "by com.day.io.file.FileUtils - looking at " + relativeTo.getResource("/").getFile() + "/resources/");
        }
        File f = new File(u.getFile());
        return f;
    }

    public static InputStream getStreamFromClassesRoot(String fileName) throws FileNotFoundException {
        log.debug("Starting getStreamFromClassesRoot (fileName : " + fileName + " , " + ")");
        return FileUtils.getStreamFromClassesRoot(fileName, FileUtils.class);
    }

    public static InputStream getStreamFromClassesRoot(String fileName, Class relativeTo) throws FileNotFoundException {
        log.debug("Starting getStreamFromClassesRoot (fileName : " + fileName + " , " + "relativeTo : " + relativeTo + " , " + ")");
        while (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        InputStream in = relativeTo.getResourceAsStream("/resources/" + fileName);
        if (in == null) {
            try {
                throw new FileNotFoundException("File " + fileName + " not found in the root of the classes directory " + "by com.day.io.file.FileUtils - looking at " + relativeTo.getResource("/").getFile() + "/resources/");
            }
            catch (NullPointerException e) {
                throw new FileNotFoundException("File " + fileName + " not found in the root of the classes directory " + "by com.day.io.file.FileUtils - looking at " + relativeTo.getName() + "'s class file.");
            }
        }
        return in;
    }

    public static byte[] getBytesFromClassesRoot(String fileName) throws IOException {
        log.debug("Starting getBytesFromClassesRoot (fileName : " + fileName + " , " + ")");
        return StreamUtils.readBytesFromStream(FileUtils.getStreamFromClassesRoot(fileName));
    }

    public static String getStringFromClassesRoot(String fileName) throws IOException {
        log.debug("Starting getStringFromClassesRoot (fileName : " + fileName + " , " + ")");
        return StreamUtils.convertStreamToString(FileUtils.getStreamFromClassesRoot(fileName));
    }

    private static byte[] append(byte[] source, byte[] addition, int length) {
        log.debug("Starting append (source : " + source + " , " + "addition : " + addition + " , " + "length : " + length + " , " + ")");
        byte[] dest = new byte[source.length + length];
        System.arraycopy(source, 0, dest, 0, source.length);
        System.arraycopy(addition, 0, dest, source.length, length);
        return dest;
    }

    public static byte[] readBytesFromStream(InputStream in) throws IOException {
        log.debug("Starting readBytesFromStream (in : " + in + " , " + ")");
        BufferedInputStream bis = new BufferedInputStream(new DataInputStream(in), 8192);
        int bytesread = 0;
        boolean firstbyte = false;
        byte[] content = new byte[]{(byte)bis.read()};
        int BUFFER_SIZE = bis.available() + 1;
        byte[] readBuffer = new byte[BUFFER_SIZE];
        while ((bytesread = bis.read(readBuffer, 0, readBuffer.length)) > 0) {
            content = FileUtils.append(content, readBuffer, bytesread);
        }
        bis.close();
        return content;
    }

    public static byte[] readBytesFromFile(File f) throws IOException {
        log.debug("Starting readBytesFromFile (f : " + f + " , " + ")");
        FileInputStream in = new FileInputStream(f);
        return FileUtils.readBytesFromStream(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(String strData, File fOutput) throws IOException {
        log.debug("Starting writeStringToFile (strData : " + strData + " , " + "fOutput : " + fOutput + " , " + ")");
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(fOutput));
            bw.write(strData);
        }
        finally {
            if (bw != null) {
                bw.close();
            }
        }
    }

    public static String readFileToString(File fInput) throws IOException {
        log.debug("Starting readFileToString (fInput : " + fInput + " , " + ")");
        String strResult = null;
        FileReader in = new FileReader(fInput);
        int iSize = (int)fInput.length();
        char[] caData = new char[iSize];
        for (int iCharsRead = 0; iCharsRead < iSize; iCharsRead += in.read(caData, iCharsRead, iSize - iCharsRead)) {
        }
        in.close();
        strResult = new String(caData);
        return strResult;
    }

    public static boolean isSame(byte[] contents, File toCheck) throws IOException {
        log.debug("Starting isSame (contents : " + contents + " , " + "toCheck : " + toCheck + " , " + ")");
        byte[] buf = new byte[(int)toCheck.length()];
        DataInputStream in = new DataInputStream(new FileInputStream(toCheck));
        int val = 0;
        int pos = 0;
        while ((val = in.read()) != -1) {
            buf[pos] = (byte)val;
            ++pos;
        }
        in.close();
        if (contents.length != buf.length) {
            return false;
        }
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i] == buf[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void copyFile(File src, File dest) throws IOException {
        log.debug("Starting copyFile (src : " + src + " , " + "dest : " + dest + " , " + ")");
        if (!src.exists()) {
            throw new IOException("FileCopy: no such source file: " + src);
        }
        if (!src.isFile()) {
            throw new IOException("FileCopy: cannot copy directory: " + src);
        }
        if (!src.canRead()) {
            throw new IOException("FileCopy: source file is unreadable: " + src);
        }
        if (dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        if (dest.exists()) {
            if (!dest.canWrite()) {
                throw new IOException("FileCopy: destination file is unwriteable: " + dest);
            }
        } else {
            File dir;
            String parent = dest.getParent();
            if (parent == null) {
                parent = System.getProperty("user.dir");
            }
            if (!(dir = new File(parent)).exists()) {
                throw new IOException("FileCopy: destination directory doesn't exist: " + parent);
            }
            if (dir.isFile()) {
                throw new IOException("FileCopy: destination is not a directory: " + parent);
            }
            if (!dir.canWrite()) {
                throw new IOException("FileCopy: destination directory is unwriteable: " + parent);
            }
        }
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytes_read;
            from = new FileInputStream(src);
            to = new FileOutputStream(dest);
            byte[] buffer = new byte[4096];
            while ((bytes_read = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytes_read);
            }
        }
        finally {
            try {
                from.close();
            }
            catch (Exception e) {}
            try {
                to.close();
            }
            catch (IOException e) {}
        }
    }
}

