/*
 * Decompiled with CFR 0.152.
 */
package com.day.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;

public class DebugFileInputStream
extends FileInputStream {
    private static HashSet inputs = new HashSet();
    private final File file;
    private boolean closed = false;
    private Throwable location = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpRegistered(PrintWriter out) {
        HashSet hashSet = inputs;
        synchronized (hashSet) {
            Iterator iter = inputs.iterator();
            while (iter.hasNext()) {
                DebugFileInputStream in = (DebugFileInputStream)iter.next();
                in.dump(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpRegistered(PrintStream out) {
        HashSet hashSet = inputs;
        synchronized (hashSet) {
            Iterator iter = inputs.iterator();
            while (iter.hasNext()) {
                DebugFileInputStream in = (DebugFileInputStream)iter.next();
                in.dump(out);
            }
        }
    }

    public DebugFileInputStream(String name) throws FileNotFoundException {
        this(new File(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugFileInputStream(File file) throws FileNotFoundException {
        super(file);
        this.file = file;
        try {
            throw new Throwable();
        }
        catch (Throwable t) {
            this.location = t;
            HashSet hashSet = inputs;
            synchronized (hashSet) {
                inputs.add(this);
            }
            return;
        }
    }

    public void close() throws IOException {
        this.closed = true;
        super.close();
    }

    public void dump(PrintWriter out) {
        out.println("path=" + this.file.getPath() + " closed=" + this.closed);
        if (!this.closed) {
            this.location.printStackTrace(out);
        }
    }

    public void dump(PrintStream out) {
        out.println("path=" + this.file.getPath() + " closed=" + this.closed);
        if (!this.closed) {
            this.location.printStackTrace(out);
        }
    }
}

