/*
 * Decompiled with CFR 0.152.
 */
package com.day.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class ChunkedDeflaterOutputStream
extends DeflaterOutputStream {
    static final String CVS_ID = "$URL: http://svn.day.com/repos/commons/tags/day-commons-io-1.1.8/src/java/com/day/io/ChunkedDeflaterOutputStream.java $ $Rev: 21923 $ $Date: 2006-08-15 22:31:09 +0200 (Tue, 15 Aug 2006) $";
    private long autoRestart = Long.MAX_VALUE;

    public ChunkedDeflaterOutputStream(OutputStream out) {
        super(out);
    }

    public ChunkedDeflaterOutputStream(OutputStream out, Deflater def) {
        super(out, def);
    }

    public ChunkedDeflaterOutputStream(OutputStream out, Deflater def, int size) {
        super(out, def, size);
    }

    public long restart() throws IOException {
        this.finish();
        long ret = this.def.getTotalOut();
        this.def.reset();
        return ret;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        if ((long)this.def.getTotalOut() > this.autoRestart) {
            this.restart();
        }
    }

    public void setAutoRestart(long len) {
        this.autoRestart = len;
    }
}

