/*
 * Decompiled with CFR 0.152.
 */
package com.day.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public abstract class AbstractBufferedImageOp
implements BufferedImageOp {
    protected final RenderingHints hints;

    protected AbstractBufferedImageOp(RenderingHints hints) {
        this.hints = hints == null ? null : new RenderingHints(hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (src == null) {
            throw new NullPointerException("src image is null");
        }
        if (src == dst) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        boolean needToConvert = false;
        ColorModel srcCM = src.getColorModel();
        BufferedImage origDst = dst;
        if (srcCM instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)srcCM;
            src = icm.convertToIntDiscrete(src.getRaster(), true);
            srcCM = src.getColorModel();
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
            ColorModel dstCM = srcCM;
            origDst = dst;
        } else {
            ColorModel dstCM = dst.getColorModel();
            if (srcCM.getColorSpace().getType() != dstCM.getColorSpace().getType()) {
                needToConvert = true;
                dst = this.createCompatibleDestImage(src, null);
                dstCM = dst.getColorModel();
            } else if (dstCM instanceof IndexColorModel) {
                dst = this.createCompatibleDestImage(src, null);
                dstCM = dst.getColorModel();
            }
        }
        this.doFilter(src, dst);
        if (needToConvert) {
            ColorConvertOp ccop = new ColorConvertOp(this.hints);
            ccop.filter(dst, origDst);
        } else if (origDst != dst) {
            Graphics2D g = origDst.createGraphics();
            try {
                g.drawImage((Image)dst, 0, 0, null);
            }
            finally {
                g.dispose();
            }
        }
        return origDst;
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return src.getRaster().getBounds();
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        Rectangle2D bounds = this.getBounds2D(src);
        int w = (int)bounds.getWidth();
        int h = (int)bounds.getHeight();
        if (destCM == null && (destCM = src.getColorModel()) instanceof IndexColorModel) {
            destCM = ColorModel.getRGBdefault();
        }
        BufferedImage image = new BufferedImage(destCM, destCM.createCompatibleWritableRaster(w, h), destCM.isAlphaPremultiplied(), null);
        return image;
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = (Point2D)srcPt.clone();
        } else {
            dstPt.setLocation(srcPt);
        }
        return dstPt;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints == null ? null : new RenderingHints(this.hints);
    }

    protected abstract void doFilter(BufferedImage var1, BufferedImage var2);
}

