/*
 * Decompiled with CFR 0.152.
 */
package com.day.durbo;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.commons.io.IOUtils;

public class DurboValue {
    private final int type;
    private byte[] bytes;
    private InputStream in;
    private long size;

    public DurboValue(int type, byte[] bytes) {
        this.type = type;
        this.bytes = bytes;
        this.size = bytes.length;
    }

    public DurboValue(int type, InputStream in, long size) {
        this.type = type;
        this.in = in;
        this.size = size;
    }

    public int getType() {
        return this.type;
    }

    public int getSize() {
        if (this.size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size greater than 2^31. Use getLength() instead.");
        }
        return (int)this.size;
    }

    public long getLength() {
        return this.size;
    }

    public byte[] getBytes() throws IOException {
        if (this.bytes == null) {
            this.bytes = IOUtils.toByteArray((InputStream)this.in);
            this.in.close();
            this.in = null;
        }
        return this.bytes;
    }

    public String getString() throws IOException {
        return new String(this.getBytes(), "utf-8");
    }

    public double getDouble() throws IOException {
        return Double.parseDouble(this.getString());
    }

    public InputStream getStream() {
        if (this.in == null) {
            return new ByteArrayInputStream(this.bytes);
        }
        return this.in;
    }

    public boolean isByteArrayBased() {
        return this.bytes != null;
    }

    public Value toJcrValue(ValueFactory factory) throws IOException, RepositoryException {
        if (this.type == 2) {
            return factory.createValue(factory.createBinary(this.getStream()));
        }
        return factory.createValue(this.getString(), this.type);
    }
}

