/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sling.server.jmx;

import com.adobe.granite.jmx.annotation.OpenTypeUtils;
import com.adobe.granite.jmx.annotation.TabularTypeInfo;
import java.util.Map;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

@TabularTypeInfo(rowType=Entry.class, indexNames={"key"})
public class SimpleMap
extends TreeMap<String, String> {
    public SimpleMap() {
    }

    public SimpleMap(TabularData tabular) {
        if (!Entry.class.getName().equals(tabular.getTabularType().getRowType().getTypeName())) {
            throw new IllegalArgumentException("Incompatible tabular data. Accepting " + Entry.class.getName());
        }
        for (Object entry : tabular.values()) {
            CompositeData e = (CompositeData)entry;
            this.put(e.get("key").toString(), e.get("value").toString());
        }
    }

    public TabularData toTabularData() {
        try {
            TabularType type = OpenTypeUtils.createTabularType(this.getClass());
            TabularDataSupport tabular = new TabularDataSupport(type);
            CompositeType itemType = OpenTypeUtils.createCompositeType(Entry.class);
            String[] itemNames = new String[]{"key", "value"};
            for (Map.Entry e : this.entrySet()) {
                Object[] itemValues = new Object[]{e.getKey(), e.getValue()};
                tabular.put(new CompositeDataSupport(itemType, itemNames, itemValues));
            }
            return tabular;
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static interface Entry {
        public String getKey();

        public String getValue();
    }
}

