/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sling.server.jmx;

import com.adobe.granite.jmx.annotation.OpenTypeUtils;
import com.adobe.granite.jmx.annotation.TabularTypeInfo;
import com.day.crx.core.cluster.ClusterNodeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

@TabularTypeInfo(rowType=ClusterNodeInfo.class, indexNames={"id"})
public class ClusterNodeInfoTabular {
    private List<ClusterNodeInfo> nodes = new ArrayList<ClusterNodeInfo>();

    public void add(ClusterNodeInfo node) {
        this.nodes.add(node);
    }

    public TabularData toTabularData() {
        try {
            TabularType type = OpenTypeUtils.createTabularType(this.getClass());
            TabularDataSupport tabular = new TabularDataSupport(type);
            CompositeType itemType = OpenTypeUtils.createCompositeType(ClusterNodeInfo.class);
            String[] itemNames = new String[]{"id", "OS", "hostname", "repositoryHome"};
            for (ClusterNodeInfo node : this.nodes) {
                Object[] itemValues = new Object[]{node.getId(), node.getOS(), node.getHostname(), node.getRepositoryHome()};
                tabular.put(new CompositeDataSupport(itemType, itemNames, itemValues));
            }
            return tabular;
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

