/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.security.token;

import com.day.crx.security.token.TokenCookie;
import com.day.crx.security.token.impl.TokenAuthenticationHandler;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.jcr.api.SlingRepository;

public class TokenUtil {
    private static final String AUTH_TYPE = "TOKEN";
    private static final String TOKEN_ATTRIBUTE = ".token";
    private static final String JCR_CREDENTIALS_ATTRIBUTE = "user.jcr.credentials";

    private TokenUtil() {
    }

    public static AuthenticationInfo createCredentials(HttpServletRequest request, HttpServletResponse response, SlingRepository repository, String userId, boolean httpOnly) throws RepositoryException {
        Session adminSession = null;
        Session userSession = null;
        try {
            adminSession = repository.loginAdministrative(null);
            SimpleCredentials sc = new SimpleCredentials(userId, new char[0]);
            sc.setAttribute(TOKEN_ATTRIBUTE, (Object)"");
            userSession = adminSession.impersonate((Credentials)sc);
            TokenCredentials tc = new TokenCredentials((String)sc.getAttribute(TOKEN_ATTRIBUTE));
            AuthenticationInfo authInfo = new AuthenticationInfo(AUTH_TYPE, userId);
            authInfo.put(JCR_CREDENTIALS_ATTRIBUTE, (Object)tc);
            TokenCookie.update(request, response, TokenUtil.getRepositoryId(), tc.getToken(), adminSession.getWorkspace().getName(), httpOnly);
            AuthenticationInfo authenticationInfo = authInfo;
            return authenticationInfo;
        }
        catch (RepositoryException e) {
            throw new RepositoryException("Failed to generate login-token: Could not access Repository", (Throwable)e);
        }
        finally {
            if (userSession != null) {
                userSession.logout();
            }
            if (adminSession != null) {
                adminSession.logout();
            }
        }
    }

    private static String getRepositoryId() {
        return TokenAuthenticationHandler.getRepositoryId();
    }
}

