/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.sc.qom;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.Query;
import javax.jcr.version.VersionException;

public abstract class AbstractQuery
implements Query {
    private final String statement;
    private final String language;
    private final Map<String, Value> bindVariables = new HashMap<String, Value>();
    private volatile long offset = 0L;
    private volatile long limit = Long.MAX_VALUE;

    protected AbstractQuery(String statement, String language, String ... variables) {
        this.statement = statement;
        this.language = language;
        for (String variable : variables) {
            this.bindVariables.put(variable, null);
        }
    }

    public String getStatement() {
        return this.statement;
    }

    public String getLanguage() {
        return this.language;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public String[] getBindVariableNames() throws RepositoryException {
        return this.bindVariables.keySet().toArray(new String[this.bindVariables.size()]);
    }

    public Value getBindValue(String varName) {
        return this.bindVariables.get(varName);
    }

    public void bindValue(String varName, Value value) throws IllegalArgumentException, RepositoryException {
        if (!this.bindVariables.containsKey(varName)) {
            throw new IllegalArgumentException("No such bind variable: " + varName);
        }
        this.bindVariables.put(varName, value);
    }

    public Node storeAsNode(String absPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
        throw new ItemNotFoundException("Not a stored query");
    }
}

