/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.util;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.HistoryItem;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.model.WorkflowModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.sling.event.JobStatusProvider;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkflowUtil {
    private static final Logger log = LoggerFactory.getLogger(WorkflowUtil.class);

    public static Collection<Event> getEvents(JobStatusProvider jobStatusProvider, WorkflowSession wfSession) {
        ArrayList<Event> wfJobs = new ArrayList<Event>();
        WorkflowModel[] models = new WorkflowModel[]{};
        try {
            models = wfSession.getModels();
        }
        catch (WorkflowException we) {
            log.error("Cannot retrieve workflow model list", (Throwable)we);
        }
        for (WorkflowModel model : models) {
            String topicName = "com/adobe/granite/workflow/job" + model.getId();
            wfJobs.addAll(jobStatusProvider.getAllJobs(topicName, new Map[0]));
        }
        Collection<Event> toJobs = jobStatusProvider.getAllJobs("com/adobe/granite/workflow/timeout/job", new Map[0]);
        wfJobs.addAll(toJobs);
        Collection<Event> extJobs = jobStatusProvider.getAllJobs("com/adobe/granite/workflow/external/job", new Map[0]);
        wfJobs.addAll(extJobs);
        log.debug("WORKFLOW JOBS: " + wfJobs.size());
        return wfJobs;
    }

    public static boolean isStale(Workflow workflow, Collection<Event> wfJobs) {
        String currentJobs = (String)((Object)workflow.getWorkflowData().getMetaDataMap().get("currentJobs", String.class));
        if (currentJobs != null) {
            if (currentJobs.startsWith("_,_")) {
                currentJobs = currentJobs.substring("_,_".length());
            }
            if (!currentJobs.equals("")) {
                String[] jobs;
                for (String job : jobs = currentJobs.split("_,_")) {
                    for (Event event : wfJobs) {
                        String jobId = (String)event.getProperty("com.adobe.granite.workflow.jobid");
                        if (jobId == null || !jobId.equals(job)) continue;
                        return false;
                    }
                }
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getAuthorizableFromLastStep(WorkflowSession session, Workflow workflow, String nodeId) throws WorkflowException {
        List<HistoryItem> historyList = session.getHistory(workflow);
        for (int i = historyList.size(); i > 0; --i) {
            HistoryItem item = historyList.get(i - 1);
            if (item.getWorkItem() == null || !item.getWorkItem().getNode().getId().equals(nodeId)) continue;
            return item.getUserId();
        }
        return null;
    }
}

