/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.offline;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.jackrabbit.util.ISO9075;

public class WordStyleSupport {
    private static final String PREFIX = "wic-";
    private static final Map<String, String> ELEMENTLOOKUP;

    public static String makeClassName(String styleName) {
        if (styleName == null) {
            return "wic-normal";
        }
        return PREFIX + ISO9075.encode(styleName.toLowerCase(Locale.ENGLISH).trim().replace(" ", ""));
    }

    public static String toHtmlElement(String className) {
        return ELEMENTLOOKUP.get(className);
    }

    static {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("wic-heading1", "h1");
        tmp.put("wic-heading2", "h2");
        tmp.put("wic-heading3", "h3");
        tmp.put("wic-heading4", "h4");
        tmp.put("wic-heading5", "h5");
        tmp.put("wic-heading6", "h6");
        ELEMENTLOOKUP = Collections.unmodifiableMap(tmp);
    }
}

