/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers;

import com.day.cq.dam.indd.PageComponent;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import com.day.cq.wcm.designimporter.parser.taghandlers.AbstractTagHandler;
import com.day.cq.wcm.designimporter.util.TagUtils;
import java.util.HashMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.ccil.cowan.tagsoup.AttributesImpl;
import org.xml.sax.Attributes;

public class DefaultComponentTagHandler
extends AbstractTagHandler {
    private String suffix;
    private String prefix;
    private String resourceType;

    public void beginHandling(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        super.beginHandling(uri, localName, qName, atts);
        if ("div".equalsIgnoreCase(localName)) {
            AttributesImpl modAttibutes = new AttributesImpl(atts);
            int index = atts.getIndex("data-cq-component");
            if (index > -1) {
                ValueMapDecorator properties = new ValueMapDecorator(new HashMap<String, Object>());
                this.resourceType = atts.getValue("data-cq-component");
                this.prefix = this.resourceType.replace("/", "");
                this.suffix = this.designImporterContext.componentSuffixGenerator.getSuffix(this.prefix);
                PageComponent textComponent = this.pageBuilder.createComponent(this.resourceType, properties, this.getNameHint());
                this.getPageComponents().add(textComponent);
                modAttibutes.removeAttribute(index);
            }
            this.startElement(uri, localName, qName, (Attributes)modAttibutes);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
    }

    public void characters(char[] ch, int start, int length) throws DesignImportException {
        String chars = new String(ch).substring(start, start + length);
        if (chars.length() > 0) {
            // empty if block
        }
    }

    public void endHandling(String uri, String localName, String qName) throws DesignImportException {
        super.endHandling(uri, localName, qName);
        if ("div".equalsIgnoreCase(localName)) {
            this.endElement(uri, localName, qName);
        }
    }

    public boolean supportsContent(HTMLContentType htmlContentType) {
        return htmlContentType == HTMLContentType.MARKUP;
    }

    private String getNameHint() {
        String name = this.prefix + this.suffix;
        return name.replace("_", "");
    }

    public Object getContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.MARKUP && this.resourceType != null) {
            String cqIncludeJspTag = "<sling:include path=\"" + this.getNameHint() + "\"" + "/>";
            return this.componentDivStartTag + cqIncludeJspTag + TagUtils.getMatchingEndTag(this.componentDivStartTag);
        }
        return null;
    }
}

