/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers;

import com.day.cq.dam.indd.PageBuilder;
import com.day.cq.dam.indd.PageComponent;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.DesignImporterContext;
import com.day.cq.wcm.designimporter.UnsupportedTagContentException;
import com.day.cq.wcm.designimporter.api.ContainerComponentProvider;
import com.day.cq.wcm.designimporter.api.HTMLContentProvider;
import com.day.cq.wcm.designimporter.api.PageComponentProvider;
import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerProvider;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import com.day.cq.wcm.designimporter.parser.taghandlers.CanvasComponentTagHandler;
import com.day.cq.wcm.designimporter.util.TagUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.ccil.cowan.tagsoup.AttributesImpl;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTagHandler
implements TagHandler,
PageComponentProvider,
HTMLContentProvider {
    protected StringBuffer cssBuffer = new StringBuffer();
    protected TagHandler delegate;
    protected StringBuffer htmlBuffer = new StringBuffer();
    protected DesignImporterContext designImporterContext;
    protected Map<String, String> metaData = new HashMap<String, String>();
    protected PageBuilder pageBuilder;
    protected List<PageComponent> pageComponents = new ArrayList<PageComponent>();
    protected List<String> referencedScripts = new ArrayList<String>();
    protected List<String> referencedStyleSheets = new ArrayList<String>();
    protected StringBuffer scriptBuffer = new StringBuffer();
    protected TagHandlerProvider tagHandlerProvider;
    private int counter;
    protected String componentDivStartTag = "";
    public static final String NAME_HINT_PROPERTY_KEY = "cq:importNameHint";

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        if (atts.getIndex("data-cq-component") != -1 && localName.matches("div|span")) {
            AttributesImpl attributes = new AttributesImpl(atts);
            if ("span".equalsIgnoreCase(localName)) {
                attributes.addAttribute("", "style", "style", "CDATA", "display: inline-block");
            }
            this.componentDivStartTag = TagUtils.getStartTag(uri, localName, qName, (Attributes)attributes);
        }
        if (this instanceof ContainerComponentProvider) {
            this.designImporterContext.componentSuffixGenerator.startComponentStack();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws DesignImportException {
        if (this.delegate != null) {
            this.delegate.characters(ch, start, length);
        } else {
            String chars = new String(ch).substring(start, start + length);
            if (chars.length() > 0) {
                this.htmlBuffer.append(StringEscapeUtils.escapeHtml((String)chars));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws DesignImportException {
        if (this.delegate != null) {
            if (--this.counter == 0) {
                List<PageComponent> components;
                this.delegate.endHandling(uri, localName, qName);
                if (this.delegate instanceof HTMLContentProvider) {
                    for (HTMLContentType contentType : HTMLContentType.values()) {
                        Object content;
                        if (!((HTMLContentProvider)((Object)this.delegate)).supportsContent(contentType) || (content = ((HTMLContentProvider)((Object)this.delegate)).getContent(contentType)) == null) continue;
                        this.pushContent(content, contentType);
                    }
                }
                if (this.delegate instanceof PageComponentProvider && (components = ((PageComponentProvider)((Object)this.delegate)).getPageComponents()) != null) {
                    this.getPageComponents().addAll(components);
                }
                this.delegate = null;
            } else {
                this.delegate.endElement(uri, localName, qName);
            }
        }
    }

    @Override
    public void endHandling(String uri, String localName, String qName) throws DesignImportException {
        if (this instanceof ContainerComponentProvider) {
            this.designImporterContext.componentSuffixGenerator.endComponentStack();
        }
    }

    @Override
    public Object getContent(HTMLContentType htmlContentType) {
        switch (htmlContentType) {
            case META: {
                return this.metaData;
            }
            case MARKUP: {
                return this.htmlBuffer.toString();
            }
            case SCRIPT_INCLUDE: {
                return this.referencedScripts;
            }
            case SCRIPT_INLINE: {
                return this.scriptBuffer.toString();
            }
            case STYLES_INLINE: {
                return this.cssBuffer.toString();
            }
            case STYLESHEET_INCLUDE: {
                return this.referencedStyleSheets;
            }
        }
        return null;
    }

    @Override
    public List<PageComponent> getPageComponents() {
        return this.pageComponents;
    }

    @Override
    public void setDesignImporterContext(DesignImporterContext designImporterContext) {
        this.designImporterContext = designImporterContext;
    }

    @Override
    public void setPageBuilder(PageBuilder pageBuilder) {
        this.pageBuilder = pageBuilder;
    }

    @Override
    public void setTagHandlerProvider(TagHandlerProvider tagHandlerProvider) {
        this.tagHandlerProvider = tagHandlerProvider;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        if (this.delegate == null) {
            this.delegate = this.tagHandlerProvider.createTagHandler(localName, atts);
            if (this.delegate != null) {
                if (this.delegate instanceof CanvasComponentTagHandler) {
                    throw new UnsupportedTagContentException("043");
                }
                this.delegate.setTagHandlerProvider(this.tagHandlerProvider);
                this.delegate.setDesignImporterContext(this.designImporterContext);
                if (this.delegate instanceof PageComponentProvider) {
                    ((PageComponentProvider)((Object)this.delegate)).setPageBuilder(this.pageBuilder);
                }
                this.delegate.beginHandling(uri, localName, qName, atts);
                this.counter = 1;
            }
        } else {
            this.delegate.startElement(uri, localName, qName, atts);
            ++this.counter;
        }
    }

    @Override
    public boolean supportsContent(HTMLContentType htmlContentType) {
        return true;
    }

    private void pushContent(Object content, HTMLContentType contentType) {
        switch (contentType) {
            case META: {
                this.metaData.putAll((Map)content);
                break;
            }
            case MARKUP: {
                this.htmlBuffer.append(content);
                break;
            }
            case SCRIPT_INCLUDE: {
                this.referencedScripts.addAll((Collection)content);
                break;
            }
            case SCRIPT_INLINE: {
                this.scriptBuffer.append(content);
                break;
            }
            case STYLES_INLINE: {
                this.cssBuffer.append(content);
                break;
            }
            case STYLESHEET_INCLUDE: {
                this.referencedStyleSheets.addAll((Collection)content);
            }
        }
    }
}

