/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser;

import com.day.cq.wcm.designimporter.parser.HTMLContent;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ModifiableHTMLContent
extends HTMLContent {
    private StringBuffer markupBuffer;
    private StringBuffer cssBuffer;
    private StringBuffer scriptBuffer;
    private List<String> referencedScripts;
    private List<String> referencedStyleSheets;
    private Map<String, String> metaData;

    public ModifiableHTMLContent(HTMLContent htmlContent) {
        this.markupBuffer = new StringBuffer((String)htmlContent.get(HTMLContentType.MARKUP));
        this.cssBuffer = new StringBuffer((String)htmlContent.get(HTMLContentType.STYLES_INLINE));
        this.scriptBuffer = new StringBuffer((String)htmlContent.get(HTMLContentType.SCRIPT_INLINE));
        this.referencedScripts = (List)htmlContent.get(HTMLContentType.SCRIPT_INCLUDE);
        this.referencedStyleSheets = (List)htmlContent.get(HTMLContentType.STYLESHEET_INCLUDE);
        this.metaData = (Map)htmlContent.get(HTMLContentType.META);
    }

    public void set(HTMLContentType htmlContentType, Object content) {
        switch (htmlContentType) {
            case META: {
                this.metaData = (Map)content;
                break;
            }
            case MARKUP: {
                this.markupBuffer = new StringBuffer((String)content);
                break;
            }
            case SCRIPT_INCLUDE: {
                this.referencedScripts = (List)content;
                break;
            }
            case SCRIPT_INLINE: {
                this.scriptBuffer = new StringBuffer((String)content);
                break;
            }
            case STYLES_INLINE: {
                this.cssBuffer = new StringBuffer((String)content);
                break;
            }
            case STYLESHEET_INCLUDE: {
                this.referencedStyleSheets = (List)content;
            }
        }
    }

    public Object get(HTMLContentType htmlContentType) {
        switch (htmlContentType) {
            case META: {
                return this.metaData;
            }
            case MARKUP: {
                return this.markupBuffer.toString();
            }
            case SCRIPT_INCLUDE: {
                return this.referencedScripts;
            }
            case SCRIPT_INLINE: {
                return this.scriptBuffer.toString();
            }
            case STYLES_INLINE: {
                return this.cssBuffer.toString();
            }
            case STYLESHEET_INCLUDE: {
                return this.referencedStyleSheets;
            }
        }
        return null;
    }

    public void add(HTMLContentType htmlContentType, Object content) {
        switch (htmlContentType) {
            case META: {
                this.metaData.putAll((Map)content);
                break;
            }
            case MARKUP: {
                this.markupBuffer.append(content);
                break;
            }
            case SCRIPT_INCLUDE: {
                this.referencedScripts.addAll((Collection)content);
                break;
            }
            case SCRIPT_INLINE: {
                this.scriptBuffer.append(content);
                break;
            }
            case STYLES_INLINE: {
                this.cssBuffer.append(content);
                break;
            }
            case STYLESHEET_INCLUDE: {
                this.referencedStyleSheets.addAll((Collection)content);
            }
        }
    }
}

