/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter;

import com.day.cq.wcm.designimporter.CanvasPageManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component
@Service(value={Filter.class})
@Properties(value={@Property(name="filter.scope", value={"request"}, propertyPrivate=true), @Property(name="filter.order", intValue={-2001}, propertyPrivate=true)})
public class CanvasPageDeleteRequestFilter
implements Filter {
    private static final String BIN_WCMCOMMAND = "/bin/wcmcommand";
    private static final String REQUEST_PARAM_PATH = "path";
    private static final String REQUEST_PARAM_CMD = "cmd";
    private static final String DELETE_PAGE_COMMAND = "deletePage";
    private static final Logger log = LoggerFactory.getLogger(CanvasPageDeleteRequestFilter.class);
    @Reference
    private CanvasPageManager canvasPageManager;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SlingHttpServletRequest slingRequest;
        if (request instanceof SlingHttpServletRequest && this.isPageDeletionRequest(slingRequest = (SlingHttpServletRequest)request)) {
            String[] pagePaths;
            for (String pagePath : pagePaths = slingRequest.getParameterValues(REQUEST_PARAM_PATH)) {
                try {
                    Resource pageResource = slingRequest.getResourceResolver().resolve(pagePath);
                    if (!this.canvasPageManager.isCanvasPage(pageResource)) continue;
                    this.canvasPageManager.deleteCanvasPageArtifacts(pageResource);
                }
                catch (Exception e) {
                    log.error("Exception in Deleting Canvas Page at location: " + pagePath + " Details " + e.getMessage());
                }
            }
        }
        chain.doFilter(request, response);
    }

    private boolean isPageDeletionRequest(SlingHttpServletRequest request) {
        return request.getPathInfo().equals(BIN_WCMCOMMAND) && DELETE_PAGE_COMMAND.equals(request.getParameter(REQUEST_PARAM_CMD));
    }

    public void destroy() {
    }

    protected void bindCanvasPageManager(CanvasPageManager canvasPageManager) {
        this.canvasPageManager = canvasPageManager;
    }

    protected void unbindCanvasPageManager(CanvasPageManager canvasPageManager) {
        if (this.canvasPageManager == canvasPageManager) {
            this.canvasPageManager = null;
        }
    }
}

