/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.core.utils;

import com.adobe.granite.security.user.util.AuthorizableUtil;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.replication.ReplicationQueue;
import com.day.cq.replication.ReplicationStatus;
import java.util.Calendar;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;

public class PageInfoUtils {
    public static JSONObject getReplicationStateObject(Resource resource, XSSAPI xssAPI) throws JSONException {
        ReplicationStatus replicationStatus = resource.adaptTo(ReplicationStatus.class);
        if (replicationStatus != null) {
            int maxQueuePos = -1;
            for (ReplicationQueue.Entry e : replicationStatus.getPending()) {
                if (e.getQueuePosition() <= maxQueuePos) continue;
                maxQueuePos = e.getQueuePosition();
            }
            return PageInfoUtils.getReplicationStateObject(resource, xssAPI, maxQueuePos);
        }
        return null;
    }

    private static void writeKey(JSONObject object, String key, Object value) throws JSONException {
        object.put(key, value);
    }

    private static void writeOptionalKey(JSONObject object, String key, Object value) throws JSONException {
        if (value != null) {
            PageInfoUtils.writeKey(object, key, value);
        }
    }

    private static void writeOptionalDateKey(JSONObject object, String key, Calendar value) throws JSONException {
        if (value != null) {
            PageInfoUtils.writeKey(object, key, value.getTimeInMillis());
        }
    }

    public static JSONObject getReplicationStateObject(Resource resource, XSSAPI xssAPI, Integer maxQueuePos) throws JSONException {
        ReplicationStatus replicationStatus = resource.adaptTo(ReplicationStatus.class);
        if (replicationStatus != null) {
            JSONObject replication = new JSONObject();
            PageInfoUtils.writeKey(replication, "numQueued", maxQueuePos + 1);
            PageInfoUtils.writeOptionalDateKey(replication, "published", replicationStatus.getLastPublished());
            String lastPublishedBy = AuthorizableUtil.getFormattedName(resource.getResourceResolver(), replicationStatus.getLastPublishedBy());
            PageInfoUtils.writeKey(replication, "publishedBy", lastPublishedBy);
            PageInfoUtils.writeKey(replication, "publishedBy_xss", lastPublishedBy != null ? xssAPI.filterHTML(lastPublishedBy) : null);
            if (replicationStatus.getLastReplicationAction() != null) {
                PageInfoUtils.writeOptionalKey(replication, "action", replicationStatus.getLastReplicationAction().name());
            }
            return replication;
        }
        return null;
    }
}

