/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.core.stats;

import com.day.cq.statistics.StatisticsService;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.core.stats.PageViewReport;
import com.day.cq.wcm.core.stats.PageViewStatistics;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true)
@Service
public class PageViewStatisticsImpl
implements PageViewStatistics {
    private static final Logger log = LoggerFactory.getLogger(PageViewStatisticsImpl.class);
    @Property
    private static final String TRACKING_URL_PROPERTY = "pageviewstatistics.trackingurl";
    @Reference(policy=ReferencePolicy.STATIC)
    private StatisticsService statistics;
    private boolean isLocal = true;
    private String trackingUrl;
    private String dataPath;

    public URL getTrackingURL() {
        return this.getURL(this.trackingUrl);
    }

    public URI getTrackingURI() {
        return this.getURI(this.trackingUrl);
    }

    public Object[] report(Page page) throws WCMException {
        if (this.isLocal) {
            return this.reportLocal(page);
        }
        log.debug("Remote reports not implemented");
        return null;
    }

    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        this.trackingUrl = (String)props.get(TRACKING_URL_PROPERTY);
        this.dataPath = this.statistics.getPath() + "/pages";
    }

    private Object[] reportLocal(Page page) throws WCMException {
        try {
            PageViewReport report = new PageViewReport(this.dataPath, page, WCMMode.PREVIEW);
            report.setPeriod(1);
            Session s = page.adaptTo(Node.class).getSession();
            Iterator result = this.statistics.runReport(s, report);
            if (result.hasNext()) {
                return (Object[])result.next();
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new WCMException(e);
        }
    }

    private URL getURL(String urlProperty) {
        if (urlProperty != null) {
            try {
                return new URL(urlProperty);
            }
            catch (MalformedURLException e) {
                log.error("Configuration contained URL that is not vald{}: {}", (Object)urlProperty, (Object)e);
            }
        }
        return null;
    }

    private URI getURI(String urlProperty) {
        if (urlProperty != null) {
            try {
                return new URI(urlProperty);
            }
            catch (URISyntaxException e) {
                log.error("Configuration contained URI that is not valid{}: {}", (Object)urlProperty, (Object)e);
            }
        }
        return null;
    }

    protected void bindStatistics(StatisticsService statisticsService) {
        this.statistics = statisticsService;
    }

    protected void unbindStatistics(StatisticsService statisticsService) {
        if (this.statistics == statisticsService) {
            this.statistics = null;
        }
    }
}

