/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.core.stats;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import com.day.cq.wcm.core.stats.PageViewPathBuilder;
import com.day.crx.statistics.Entry;
import com.day.crx.statistics.PathBuilder;
import java.util.Calendar;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;

public class PageView
extends Entry {
    public static final String VIEWS = "views";
    public static final String ROLLING_WEEK_COUNT = "rollingWeekViews";
    public static final String ROLLING_MONTH_COUNT = "rollingMonthViews";
    private final Page page;
    private final WCMMode mode;

    public PageView(String pathPrefix, Page page, WCMMode mode) {
        super(pathPrefix);
        this.page = page;
        this.mode = mode;
    }

    protected PathBuilder getPathBuilder() {
        return new PageViewPathBuilder(this.page.getPath());
    }

    public void write(Node node) throws RepositoryException {
        Node month = node.getParent();
        Node year = month.getParent();
        this.updateViews(node);
        this.updateViews(month);
        this.updateViews(year);
        this.updateCumulativeViews(node, ROLLING_WEEK_COUNT, 6);
        this.updateCumulativeViews(node, ROLLING_MONTH_COUNT, 29);
    }

    private void updateViews(Node node) throws RepositoryException {
        long viewCount = 0L;
        if (node.hasProperty(VIEWS)) {
            viewCount = node.getProperty(VIEWS).getLong();
        }
        node.setProperty(VIEWS, ++viewCount);
        long modeViewCount = 0L;
        String modeViewProp = "views-" + (Object)((Object)this.mode);
        if (node.hasProperty(modeViewProp)) {
            modeViewCount = node.getProperty(modeViewProp).getLong();
        }
        node.setProperty(modeViewProp, ++modeViewCount);
    }

    private void updateCumulativeViews(Node node, String propertyName, int numDays) throws RepositoryException {
        long viewCount = node.hasProperty(propertyName) ? node.getProperty(propertyName).getLong() : this.getCumulativeCount(node, numDays, VIEWS);
        node.setProperty(propertyName, ++viewCount);
        propertyName = propertyName + "-" + (Object)((Object)this.mode);
        long modeViewCount = node.hasProperty(propertyName) ? node.getProperty(propertyName).getLong() : this.getCumulativeCount(node, numDays, "views-" + (Object)((Object)this.mode));
        node.setProperty(propertyName, ++modeViewCount);
    }

    private long getCumulativeCount(Node node, int numDays, String propName) throws RepositoryException, ValueFormatException {
        long viewCount = 0L;
        Session session = node.getSession();
        PathBuilder builder = this.getPathBuilder();
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(this.getTimestamp());
        PageView view = new PageView(this.getPathPrefix(), this.page, this.mode);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < numDays; ++i) {
            buffer.setLength(0);
            date.add(5, -1);
            view.setTimestamp(date.getTimeInMillis());
            builder.formatPath(view, buffer);
            String path = buffer.toString();
            try {
                Node n;
                Item item = session.getItem(path);
                if (!item.isNode() || !(n = (Node)item).hasProperty(propName)) continue;
                viewCount += n.getProperty(propName).getLong();
                continue;
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
        }
        return viewCount;
    }
}

