/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.core.mvt;

import com.day.cq.statistics.StatisticsService;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.core.mvt.CTRReport;
import com.day.cq.wcm.core.mvt.MVTStatistics;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="%mvtstatistics.name", description="%mvtstatistics.description")
@Service
public class MVTStatisticsImpl
implements MVTStatistics {
    private static final Logger log = LoggerFactory.getLogger(MVTStatisticsImpl.class);
    @Property
    private static final String TRACKING_URL_PROPERTY = "mvtstatistics.trackingurl";
    @Reference(policy=ReferencePolicy.STATIC)
    private StatisticsService statistics;
    private String trackingUrl;
    private String dataPath;

    @Override
    public URL getTrackingURL() {
        return this.getURL(this.trackingUrl);
    }

    @Override
    public URI getTrackingURI() {
        return this.getURI(this.trackingUrl);
    }

    @Override
    public Iterable<Object[]> report(Page page) throws WCMException {
        try {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            CTRReport report = new CTRReport(this.dataPath, page);
            Iterator it = this.statistics.runReport(report);
            while (it.hasNext()) {
                result.add((Object[])it.next());
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new WCMException(e);
        }
    }

    protected void activate(ComponentContext context) {
        Dictionary props = context.getProperties();
        this.trackingUrl = (String)props.get(TRACKING_URL_PROPERTY);
        this.dataPath = this.statistics.getPath() + "/mvt";
    }

    private URL getURL(String urlProperty) {
        if (urlProperty != null) {
            try {
                return new URL(urlProperty);
            }
            catch (MalformedURLException e) {
                log.error("Configuration contained URL that is not valid{}: {}", (Object)urlProperty, (Object)e);
            }
        }
        return null;
    }

    private URI getURI(String urlProperty) {
        if (urlProperty != null) {
            try {
                return new URI(urlProperty);
            }
            catch (URISyntaxException e) {
                log.error("Configuration contained URI that is not valid{}: {}", (Object)urlProperty, (Object)e);
            }
        }
        return null;
    }

    protected void bindStatistics(StatisticsService statisticsService) {
        this.statistics = statisticsService;
    }

    protected void unbindStatistics(StatisticsService statisticsService) {
        if (this.statistics == statisticsService) {
            this.statistics = null;
        }
    }
}

