/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.spellchecker;

import com.day.cq.spellchecker.SpellCheckException;
import com.day.cq.spellchecker.WordCheckResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONStringer;

public class TextCheckResult {
    private final String text;
    private final boolean isHtml;
    private final String language;
    private final List<WordResult> results;

    public TextCheckResult(String text, boolean isHtml, String language) {
        this.text = text;
        this.isHtml = isHtml;
        this.language = language;
        this.results = new ArrayList<WordResult>(10);
    }

    public void addWordResult(int startPos, int charCnt, WordCheckResult wordResult) {
        this.results.add(new WordResult(startPos, charCnt, wordResult));
    }

    public WordResult getWordResult(int pos) {
        for (WordResult wordResult : this.results) {
            int startPos = wordResult.getStartPos();
            int endPos = startPos + wordResult.getCharCnt();
            if (pos < startPos || pos >= endPos) continue;
            return wordResult;
        }
        return null;
    }

    public String getText() {
        return this.text;
    }

    public boolean isHtml() {
        return this.isHtml;
    }

    public String getLanguage() {
        return this.language;
    }

    public String toJsonString() throws SpellCheckException {
        return this.toJsonString(false);
    }

    public String toJsonString(boolean sparse) throws SpellCheckException {
        try {
            JSONStringer json = new JSONStringer();
            json.object();
            json.key("language");
            json.value(this.language);
            json.key("words");
            json.array();
            for (WordResult wordResult : this.results) {
                if (sparse && wordResult.getResult().isCorrect()) continue;
                json.object();
                json.key("start");
                json.value(wordResult.getStartPos());
                json.key("chars");
                json.value(wordResult.getCharCnt());
                json.key("result");
                wordResult.getResult().addToJsonStringer(json);
                json.endObject();
            }
            json.endArray();
            json.endObject();
            return json.toString();
        }
        catch (JSONException je) {
            throw new SpellCheckException("Could not JSON-ify spellcheck result.", je);
        }
    }

    private static class WordResult {
        private final int startPos;
        private final int charCnt;
        private final WordCheckResult result;

        WordResult(int startPos, int charCnt, WordCheckResult result) {
            this.startPos = startPos;
            this.charCnt = charCnt;
            this.result = result;
        }

        public int getStartPos() {
            return this.startPos;
        }

        public int getCharCnt() {
            return this.charCnt;
        }

        public WordCheckResult getResult() {
            return this.result;
        }
    }
}

