/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.security.util;

import com.day.cq.security.util.AclPolicy;
import java.security.Principal;
import java.util.HashSet;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlPolicy;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.sling.api.SlingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CRXPolicyManager {
    private final JackrabbitSession session;
    private final AccessControlManager acManager;
    private final PrincipalManager principalManager;
    private static final Logger log = LoggerFactory.getLogger(CRXPolicyManager.class);

    public CRXPolicyManager(Session session) throws RepositoryException {
        if (!(session instanceof JackrabbitSession)) {
            throw new RepositoryException("CRXPolicyManager only usable with a jackrabbit session.");
        }
        this.session = (JackrabbitSession)session;
        this.acManager = session.getAccessControlManager();
        this.principalManager = this.session.getPrincipalManager();
    }

    public boolean applyPolicy(String path, AclPolicy policy) throws AccessDeniedException {
        boolean success = false;
        try {
            boolean modified = false;
            if (this.session.itemExists(path)) {
                JackrabbitAccessControlList acl = this.getAcl(path);
                if (acl != null) {
                    for (AclPolicy.Entry entry : policy.getEntries()) {
                        if (!this.principalManager.hasPrincipal(entry.getPrincipal())) continue;
                        Principal principal = this.principalManager.getPrincipal(entry.getPrincipal());
                        if (this.setAce(principal, entry, acl)) {
                            modified = true;
                            log.debug("Allow not contained in ACL on {}: added for {}", (Object)path, (Object)principal.getName());
                            continue;
                        }
                        log.debug("Allow for {} contained in ACL on {}: no changes", (Object)principal.getName(), (Object)path);
                    }
                }
                if (modified) {
                    this.acManager.setPolicy(path, (AccessControlPolicy)acl);
                    this.session.save();
                }
            }
            success = true;
            boolean bl = modified;
            return bl;
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new SlingException(e.getMessage(), e);
        }
        finally {
            if (!success) {
                try {
                    this.session.refresh(false);
                }
                catch (RepositoryException e) {
                    log.error("Failed to revert pending changes.", (Throwable)e);
                    throw new SlingException(e.getMessage(), e);
                }
            }
        }
    }

    public AclPolicy privatePolicy() {
        return new AclPolicy(this.principalManager.getEveryone().getName(), new String[]{"{http://www.jcp.org/jcr/1.0}all"}, false);
    }

    private JackrabbitAccessControlList getAcl(String path) throws RepositoryException {
        AccessControlPolicyIterator app = this.acManager.getApplicablePolicies(path);
        while (app.hasNext()) {
            AccessControlPolicy pol = app.nextAccessControlPolicy();
            if (!(pol instanceof JackrabbitAccessControlPolicy)) continue;
            log.debug("No Policy present create a new ACL Policy");
            return (JackrabbitAccessControlList)pol;
        }
        for (AccessControlPolicy pol : this.acManager.getPolicies(path)) {
            if (!(pol instanceof JackrabbitAccessControlPolicy)) continue;
            log.debug("Found existing ACL Policy");
            return (JackrabbitAccessControlList)pol;
        }
        return null;
    }

    private boolean setAce(Principal principal, AclPolicy.Entry entry, JackrabbitAccessControlList acl) throws RepositoryException {
        Privilege[] privileges = this.privilegesFromName(entry.getPrivileges());
        if (privileges.length < 0) {
            log.debug("No Privleges for {} to set on {}: no change", (Object)principal, (Object)acl.getPath());
            return false;
        }
        acl.addEntry(principal, privileges, entry.isAllow());
        return true;
    }

    private Privilege[] privilegesFromName(String[] names) throws RepositoryException {
        HashSet<Privilege> privSet = new HashSet<Privilege>();
        for (String privName : names) {
            try {
                privSet.add(this.acManager.privilegeFromName(privName));
            }
            catch (AccessControlException e) {
                log.debug("Could not resolve Privilege for name {}: {}", (Object)privName, (Object)e);
            }
        }
        return privSet.toArray(new Privilege[privSet.size()]);
    }
}

