/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.searchpromote.xml.result;

import com.day.cq.searchpromote.xml.result.ResultEntity;
import com.day.cq.searchpromote.xml.result.ResultParser;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Query
implements ResultEntity {
    private static final String USER_QUERY_NODE = "user-query";
    private static final String UPPER_RESULTS_NODE = "upper-results";
    private static final String LOWER_RESULTS_NODE = "lower-results";
    private static final String TOTAL_RESULTS_NODE = "total-results";
    private String userQuery;
    private Long upperResult;
    private Long lowerResult;
    private Long totalResults;

    public void parse(XMLEventReader reader) throws Exception {
        XMLEvent nextEvent;
        while (reader.hasNext() && !(nextEvent = ResultParser.getNextEvent(reader)).isEndElement()) {
            String data;
            StartElement element = nextEvent.asStartElement();
            if (element.getName().getLocalPart().equals(USER_QUERY_NODE)) {
                data = reader.nextEvent().asCharacters().getData();
                this.userQuery = data != null ? new String(data.getBytes("ISO-8859-1"), "UTF-8") : null;
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (element.getName().getLocalPart().equals(UPPER_RESULTS_NODE)) {
                data = reader.nextEvent().asCharacters().getData();
                this.upperResult = Long.parseLong(data);
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (element.getName().getLocalPart().equals(LOWER_RESULTS_NODE)) {
                data = reader.nextEvent().asCharacters().getData();
                this.lowerResult = Long.parseLong(data);
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (element.getName().getLocalPart().equals(TOTAL_RESULTS_NODE)) {
                data = reader.nextEvent().asCharacters().getData();
                this.totalResults = Long.parseLong(data);
                ResultParser.getNextEvent(reader);
                continue;
            }
            ResultParser.parseUnknownTag(reader);
        }
    }

    public String getUserQuery() {
        return this.userQuery;
    }

    public Long getUpperResult() {
        return this.upperResult;
    }

    public Long getLowerResult() {
        return this.lowerResult;
    }

    public Long getTotalResults() {
        return this.totalResults;
    }
}

