/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.searchpromote.xml.result;

import com.day.cq.searchpromote.xml.result.PageList;
import com.day.cq.searchpromote.xml.result.ResultEntity;
import com.day.cq.searchpromote.xml.result.ResultPage;
import com.day.cq.searchpromote.xml.result.ResultParser;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pagination
implements ResultEntity {
    private static final String TOTAL_PAGES_NODE = "total-pages";
    private static final String PAGES_NODE = "pages";
    private Long totalPages;
    private PageList pageList;

    @Override
    public void parse(XMLEventReader reader) throws Exception {
        XMLEvent event;
        while (reader.hasNext() && !(event = ResultParser.getNextEvent(reader)).isEndElement()) {
            StartElement startElement = event.asStartElement();
            String localPart = startElement.getName().getLocalPart();
            if (localPart.equals(TOTAL_PAGES_NODE)) {
                this.totalPages = Long.parseLong(reader.nextEvent().asCharacters().getData());
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (localPart.equals(PAGES_NODE)) {
                this.pageList = new PageList();
                this.pageList.parse(reader);
                continue;
            }
            ResultParser.parseUnknownTag(reader);
        }
    }

    public Long getTotalPages() {
        return this.totalPages;
    }

    public List<ResultPage> getResultPages() {
        ArrayList<ResultPage> pages = new ArrayList<ResultPage>();
        for (ResultPage p : this.pageList.getPages()) {
            if (!p.getPosition().matches("\\d+")) continue;
            pages.add(p);
        }
        return pages;
    }

    public ResultPage getFirst() {
        return this.get("first");
    }

    public ResultPage getLast() {
        return this.get("last");
    }

    public ResultPage getPrevious() {
        return this.get("previous");
    }

    public ResultPage getNext() {
        return this.get("next");
    }

    public ResultPage getViewall() {
        return this.get("viewall");
    }

    public Boolean hasNext() {
        return this.checkFor("next");
    }

    public Boolean hasPrevious() {
        return this.checkFor("previous");
    }

    public Boolean hasFirst() {
        return this.checkFor("first");
    }

    public Boolean hasLast() {
        return this.checkFor("last");
    }

    public Boolean hasViewall() {
        return this.checkFor("viewall");
    }

    public Integer getSize() {
        return this.pageList.getPages().size();
    }

    private ResultPage get(String position) {
        for (ResultPage p : this.pageList.getPages()) {
            if (!position.equalsIgnoreCase(p.getPosition())) continue;
            return p;
        }
        return null;
    }

    private Boolean checkFor(String position) {
        return this.get(position) != null;
    }
}

