/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.searchpromote.xml.result;

import com.day.cq.searchpromote.xml.result.ResultEntity;
import com.day.cq.searchpromote.xml.result.ResultParser;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class MenuItem
implements ResultEntity {
    private static final String LABEL_NODE = "label";
    private static final String VALUE_NODE = "value";
    private static final String LINK_NODE = "link";
    private String label;
    private String value;
    private String queryString;
    private boolean selected;

    public MenuItem(boolean selected) {
        this.selected = selected;
    }

    public void parse(XMLEventReader reader) throws Exception {
        XMLEvent nextEvent;
        while (reader.hasNext() && !(nextEvent = ResultParser.getNextEvent(reader)).isEndElement()) {
            String data;
            StartElement element = nextEvent.asStartElement();
            if (element.getName().getLocalPart().equals(LABEL_NODE)) {
                this.label = data = reader.nextEvent().asCharacters().getData();
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (element.getName().getLocalPart().equals(VALUE_NODE)) {
                this.value = data = reader.nextEvent().asCharacters().getData();
                ResultParser.getNextEvent(reader);
                continue;
            }
            if (element.getName().getLocalPart().equals(LINK_NODE)) {
                this.queryString = data = reader.nextEvent().asCharacters().getData();
                ResultParser.getNextEvent(reader);
                continue;
            }
            ResultParser.parseUnknownTag(reader);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getValue() {
        return this.value;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

