/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.writer;

import com.day.cq.search.Query;
import com.day.cq.search.result.Hit;
import com.day.cq.search.writer.ResultHitWriter;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

@Component(metatype=false, factory="com.day.cq.search.writer.ResultHitWriter/simple")
public class SimpleHitWriter
implements ResultHitWriter {
    public static final long KILO_BYTE = 1024L;
    public static final long MEGA_BYTE = 0x100000L;
    public static final long GIGA_BYTE = 0x40000000L;
    public static final long TERA_BYTE = 0x10000000000L;
    public static final long PETA_BYTE = 0x4000000000000L;

    public void write(Hit hit, JSONWriter writer, Query query) throws RepositoryException, JSONException {
        SimpleHitWriter.writeSimpleJson(hit, writer);
    }

    public static void writeSimpleJson(Hit hit, JSONWriter writer) throws RepositoryException, JSONException {
        String mimeType;
        long size;
        Calendar cal;
        long created;
        Resource resource = hit.getResource();
        ResourceMetadata metadata = resource.getResourceMetadata();
        ValueMap properties = hit.getProperties();
        writer.key("path").value(hit.getPath());
        String excerpt = hit.getExcerpt();
        if (excerpt != null) {
            writer.key("excerpt").value(excerpt);
        }
        String name = Text.getName(hit.getPath());
        writer.key("name").value(name);
        writer.key("title").value(properties.get("jcr:title", name));
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long lastModified = metadata.getModificationTime();
        if (lastModified < 0L) {
            Calendar cal2 = (Calendar)properties.get("cq:lastModified");
            if (cal2 == null) {
                cal2 = (Calendar)properties.get("jcr:lastModified");
            }
            if (cal2 != null) {
                lastModified = cal2.getTimeInMillis();
            }
        }
        if (lastModified >= 0L) {
            writer.key("lastModified").value(format.format(new Date(lastModified)));
        }
        if ((created = metadata.getCreationTime()) < 0L && (cal = (Calendar)properties.get("jcr:created")) != null) {
            created = cal.getTimeInMillis();
        }
        if (created >= 0L) {
            writer.key("created").value(format.format(new Date(created)));
        }
        if ((size = metadata.getContentLength()) < 0L) {
            resource.adaptTo(InputStream.class);
            size = metadata.getContentLength();
        }
        if (size >= 0L) {
            String humanSize = size >= 0x4000000000000L ? size / 0x4000000000000L + " PB" : (size >= 0x10000000000L ? size / 0x10000000000L + " TB" : (size >= 0x40000000L ? size / 0x40000000L + " GB" : (size >= 0x100000L ? size / 0x100000L + " MB" : (size >= 1024L ? size / 1024L + " KB" : size + " Bytes"))));
            writer.key("size").value(humanSize);
        }
        if ((mimeType = metadata.getContentType()) == null) {
            mimeType = (String)properties.get("jcr:mimeType");
        }
        if (mimeType != null) {
            writer.key("mimeType").value(mimeType);
        }
    }
}

