/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.reporting.helpers;

import com.day.cq.reporting.impl.snapshots.AggregationInterval;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

public class Util {
    private Util() {
    }

    public static long createTimeStamp(Calendar cal) {
        long ds = cal.get(1);
        ds *= 100L;
        ds += (long)(cal.get(2) + 1);
        ds *= 100L;
        ds += (long)cal.get(5);
        ds *= 100L;
        ds += (long)cal.get(11);
        ds *= 100L;
        ds += (long)cal.get(12);
        ds *= 100L;
        return ds += (long)cal.get(13);
    }

    public static void writeToJSON(JSONWriter writer, AggregationInterval interval, Calendar cal, TimeZone timeZone, Locale locale) throws JSONException {
        writer.object();
        writer.key("tc").value(cal.getTimeInMillis());
        DateFormat df = interval == AggregationInterval.HOUR ? DateFormat.getTimeInstance(3, locale) : (interval != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateTimeInstance(3, 3, locale));
        df.setTimeZone(timeZone);
        writer.key("display").value(df.format(cal.getTime()));
        writer.endObject();
    }

    public static void clearTime(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static boolean arrayContainsString(String[] array, String str) {
        if (array == null) {
            return false;
        }
        for (String item : array) {
            if (!(item != null ? item.equals(str) : str == null)) continue;
            return true;
        }
        return false;
    }

    public static String getRenderTypeFromRequest(SlingHttpServletRequest req) {
        String typeSelector;
        String[] selectors;
        String renderType = null;
        RequestPathInfo pathInfo = req.getRequestPathInfo();
        String[] stringArray = selectors = pathInfo != null ? pathInfo.getSelectors() : null;
        if (selectors != null && selectors.length >= 1 && ((typeSelector = selectors[0]).equals("tabular") || typeSelector.equals("chart"))) {
            renderType = typeSelector;
        }
        return renderType;
    }

    public static String getChartIdFromRequest(SlingHttpServletRequest req) {
        String typeSelector;
        String[] selectors;
        String chartId = null;
        RequestPathInfo pathInfo = req.getRequestPathInfo();
        String[] stringArray = selectors = pathInfo != null ? pathInfo.getSelectors() : null;
        if (selectors != null && selectors.length >= 2 && (typeSelector = selectors[0]).equals("chart")) {
            chartId = selectors[1];
        }
        return chartId;
    }

    public static boolean isSingleViewRendering(SlingHttpServletRequest req) {
        return Util.getRenderTypeFromRequest(req) != null;
    }

    public static Integer[] getRenderSizeFromRequest(SlingHttpServletRequest req) {
        int selectorCnt;
        String[] selectors;
        Integer[] size = new Integer[2];
        RequestPathInfo pathInfo = req.getRequestPathInfo();
        String[] stringArray = selectors = pathInfo != null ? pathInfo.getSelectors() : null;
        if (selectors != null && (selectorCnt = selectors.length) >= 3) {
            Integer width = null;
            try {
                width = Integer.parseInt(selectors[selectorCnt - 2]);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            Integer height = null;
            try {
                height = Integer.parseInt(selectors[selectorCnt - 1]);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            size[0] = width;
            size[1] = height;
        }
        return size;
    }

    public static String getChartLayoutFromRequest(SlingHttpServletRequest req) {
        String typeSelector;
        String[] selectors;
        String chartLayout = null;
        RequestPathInfo pathInfo = req.getRequestPathInfo();
        String[] stringArray = selectors = pathInfo != null ? pathInfo.getSelectors() : null;
        if (selectors != null && selectors.length >= 3 && (typeSelector = selectors[0]).equals("chart")) {
            String chartLayoutCandidate = selectors[2];
            if (chartLayoutCandidate.equals("h")) {
                chartLayout = "horizontal";
            } else if (chartLayoutCandidate.equals("v")) {
                chartLayout = "vertical";
            }
        }
        return chartLayout;
    }

    public static boolean equalsNullAware(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        return obj1 != null && obj1.equals(obj2);
    }
}

