/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization;

import com.adobe.granite.security.user.UserProperties;
import java.lang.reflect.Method;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPropertiesUtil {
    private static final Logger log = LoggerFactory.getLogger(UserPropertiesUtil.class);

    public static boolean isAnonymous(UserProperties userProperties) {
        return userProperties == null || userProperties.getAuthorizableID().equals("anonymous");
    }

    public static boolean isAnonymous(SlingHttpServletRequest request) {
        UserProperties userProperties = (UserProperties)request.adaptTo(UserProperties.class);
        return UserPropertiesUtil.isAnonymous(userProperties);
    }

    public static String getValue(UserProperties userProperties, String propertyName) {
        String getterName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            Method method = UserProperties.class.getMethod(getterName, new Class[0]);
            Object valueObject = method.invoke((Object)userProperties, (Object[])null);
            return valueObject != null ? valueObject.toString() : "";
        }
        catch (Exception e) {
            log.debug("getValue: error getting value via reflection: ", (Throwable)e);
            try {
                return userProperties.getProperty(propertyName);
            }
            catch (RepositoryException e2) {
                log.error("getValue: error getting value from user properties: ", (Throwable)e2);
                return null;
            }
        }
    }
}

