/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.landingpage.parser.taghandlers.mbox;

import com.day.cq.dam.indd.PageComponent;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.UnsupportedTagContentException;
import com.day.cq.wcm.designimporter.api.ContainerComponentProvider;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import com.day.cq.wcm.designimporter.parser.taghandlers.AbstractTagHandler;
import com.day.cq.wcm.designimporter.parser.taghandlers.CanvasComponentBuilder;
import com.day.cq.wcm.designimporter.parser.taghandlers.DefaultTagHandler;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.jcr.RepositoryException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBoxExperienceTagHandler
extends AbstractTagHandler
implements EventHandler,
ContainerComponentProvider {
    private String segment;
    private ServiceRegistration serviceRegistration;
    private Logger logger = LoggerFactory.getLogger(MBoxExperienceTagHandler.class);
    private boolean isDefaultExperience;
    private boolean componentGenerationRequired;
    private String resourceType;
    private List<PageComponent> offerComponents;

    public boolean isDefaultExperience() {
        return this.isDefaultExperience;
    }

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        super.beginHandling(uri, localName, qName, atts);
        String cqExperience = atts.getValue("data-cq-experience");
        if ("default".equalsIgnoreCase(cqExperience)) {
            this.isDefaultExperience = true;
        }
        this.segment = atts.getValue("data-cq-segment");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException, UnsupportedTagContentException {
        super.startElement(uri, localName, qName, atts);
        if (this.delegate instanceof DefaultTagHandler) {
            this.componentGenerationRequired = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws DesignImportException {
        super.characters(ch, start, length);
        if (this.delegate == null && new String(ch, start, length).trim().length() > 0) {
            this.componentGenerationRequired = true;
        }
    }

    @Override
    public void endHandling(String uri, String localName, String qName) throws DesignImportException {
        super.endHandling(uri, localName, qName);
        if (this.componentGenerationRequired) {
            this.resourceType = this.deriveResourceType();
            PageComponent wrapper = this.pageBuilder.createComponent(this.resourceType);
            wrapper.getChildComponents().addAll(this.getPageComponents());
            this.pageComponents = new ArrayList();
            this.pageComponents.add(wrapper);
            String[] topics = new String[]{"com/day/cq/wcm/designimporter/CanvasPageBuilder/COMPLETE"};
            Hashtable<String, String[]> props = new Hashtable<String, String[]>();
            ((Dictionary)props).put("event.topics", topics);
            if (this.designImporterContext.bundleContext != null) {
                this.serviceRegistration = this.designImporterContext.bundleContext.registerService(EventHandler.class.getName(), (Object)this, props);
            }
        }
        if (!this.isDefaultExperience) {
            this.offerComponents = new ArrayList<PageComponent>();
            this.offerComponents.addAll(this.getPageComponents());
            this.pageComponents = new ArrayList();
        }
    }

    @Override
    public boolean supportsContent(HTMLContentType htmlContentType) {
        return false;
    }

    public List<PageComponent> getOfferComponents() {
        return this.offerComponents;
    }

    public String getSegment() {
        return this.segment;
    }

    public void handleEvent(Event event) {
        if (this.componentGenerationRequired) {
            try {
                CanvasComponentBuilder mboxOfferComponentBuilder = new CanvasComponentBuilder();
                mboxOfferComponentBuilder.setResourceType(this.resourceType);
                mboxOfferComponentBuilder.setSession(this.designImporterContext.designNode.getSession());
                mboxOfferComponentBuilder.appendScriptContent(this.htmlBuffer.toString());
                mboxOfferComponentBuilder.build();
            }
            catch (RepositoryException e) {
                this.logger.error("Error occurred generating the anybox offer component");
            }
        }
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }

    private String deriveResourceType() {
        Page page = this.designImporterContext.page;
        String htmlName = this.designImporterContext.htmlName;
        String uniqueId = page.getPath().replace("/content/campaigns/", "").replace('/', '-') + "-" + htmlName;
        String mboxResourceType = null;
        try {
            String pageName = page.getPath().replaceAll(".*/", "");
            String strippedPath = page.getPath().replace("/content/campaigns/", "");
            int indexOfSlash = strippedPath.indexOf(47);
            String brand = strippedPath.replaceFirst("/.*", "");
            mboxResourceType = brand + "/components/mbox/" + uniqueId + "-" + "mbox" + this.designImporterContext.componentSuffixGenerator.getSuffix("mbox");
        }
        catch (Exception e) {
            this.logger.error("Error occured while trying to deduce the mbox resource type", (Throwable)e);
        }
        return mboxResourceType;
    }
}

