/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.landingpage.leadform.creator;

import com.day.cq.contentsync.handler.util.RequestResponseFactory;
import com.day.cq.i18n.I18n;
import com.day.cq.mcm.landingpage.leadform.AuthorizableLeadFormRequestProperties;
import com.day.cq.security.Group;
import com.day.cq.security.NoSuchAuthorizableException;
import com.day.cq.security.UserManager;
import com.day.cq.security.profile.Profile;
import com.day.cq.wcm.api.Page;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.auth.core.AuthUtil;
import org.apache.sling.engine.SlingRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service(value={LeadFormsCreator.class})
public class LeadFormsCreator {
    public static final String FORMSTART = ":formstart";
    public static final String REP_USER_ID = "rep:userId";
    public static final String EMAIL = "email";
    public static final String AUTHORIZABLE_ID = "authorizableId";
    public static final String REP_PASSWORD = "rep:password";
    public static final String CQ_AUTHORIZABLE_CATEGORY = "cq:authorizableCategory";
    public static final String MCM = "mcm";
    public static final String GROUP_NAME = "groupName";
    public static final String CREATE_GROUP = "createGroup";
    public static final String CREATE_USER = "createUser";
    public static final String ADD_MEMBERS = "addMembers";
    public static final String LIBS_GRANITE_SECURITY_POST_AUTHORIZABLES = "/libs/granite/security/post/authorizables";
    public static final String ERR_01 = "Err_01";
    public static final String ERR_02 = "Err_02";
    public static final String ERR_03 = "Err_03";
    public static final String ERR_04 = "Err_04";
    protected static final String EXTENSION = "html";
    protected static final String SELECTOR = "cta-form";
    protected static final String ATTR_RESOURCE = LeadFormsCreator.class.getName() + "/resource";
    protected static final String PARAM_GROUP_NAME = "groupName";
    protected static final String PARAM_INTERMEDIATE_PATH = "intermediatePath";
    protected static final String PARAM_PASSWORD = "rep:password";
    protected static final String PARAM_SUBMIT = "Submit";
    public static final String PROFILE_PATH = "path";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Set<String> RESERVED = new HashSet<String>();
    @Reference
    private RequestResponseFactory requestResponseFactory;
    @Reference
    private SlingRequestProcessor slingRequestProcessor;

    public static Iterator<Resource> getFormElements(Resource formResource) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        Iterator<Resource> iter = ResourceUtil.listChildren(ResourceUtil.getParent(formResource));
        LeadFormsCreator.collectFormElements(list, iter);
        return list.iterator();
    }

    private static boolean collectFormElements(List<Resource> list, Iterator<Resource> iter) {
        boolean stop = false;
        while (!stop && iter.hasNext()) {
            Resource n = iter.next();
            if (n.getResourceType().startsWith("mcm/components/cta-form/") || n.getResourceSuperType() != null && n.getResourceSuperType().startsWith("mcm/components/cta-form/")) {
                list.add(n);
                continue;
            }
            Iterator<Resource> cI = ResourceUtil.listChildren(n);
            if (cI == null) continue;
            stop = LeadFormsCreator.collectFormElements(list, cI);
        }
        return stop;
    }

    public static void printTitle(String fieldId, String title, boolean required, boolean hideLabel, String className, Writer out) throws IOException {
        out.write("<div class=\"form_leftcol\"");
        if (hideLabel) {
            out.write(" style=\"display: none;\"");
        }
        title = title != null && title.length() > 0 ? StringEscapeUtils.escapeHtml4((String)title) : "&nbsp;";
        out.write(">");
        String titileClassName = "form_leftcollabel" + (!StringUtils.isEmpty((String)className) ? " " + className : "");
        titileClassName = StringEscapeUtils.escapeHtml4((String)titileClassName);
        out.write("<div class=\"" + titileClassName + "\">");
        if (fieldId != null) {
            fieldId = StringEscapeUtils.escapeHtml4((String)fieldId);
            out.write("<label for=\"" + fieldId + "\">" + title + "</label>");
        } else {
            out.write("<span>" + title + "</span>");
        }
        out.write("</div>");
        out.write("<div class=\"form_leftcolmark\">");
        if (!hideLabel) {
            if (required) {
                out.write(" *");
            } else {
                out.write("&nbsp;");
            }
        }
        out.write("</div>");
        out.write("</div>\n");
    }

    private static Map<String, String[]> getActionParameterMap(Resource resource, HttpServletRequest request) {
        Map unmodifiableMap = request.getParameterMap();
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(unmodifiableMap);
        ValueMap values = ResourceUtil.getValueMap(resource);
        Set keyset = values.keySet();
        for (String key : keyset) {
            if (!key.equals("groupName") && !key.equals(PARAM_INTERMEDIATE_PATH) && !key.equals("rep:password") && !key.equals(REP_USER_ID) && !key.equals(CQ_AUTHORIZABLE_CATEGORY)) continue;
            parameterMap.put(key, new String[]{(String)((Object)values.get(key, String.class))});
        }
        return parameterMap;
    }

    private static String getParameter(Resource resource, HttpServletRequest request, String paramName) {
        String paramValue = request.getParameter(paramName);
        if (paramValue == null) {
            ValueMap values = ResourceUtil.getValueMap(resource);
            paramValue = (String)((Object)values.get(paramName, String.class));
        }
        return paramValue;
    }

    @Deprecated
    public void createUser(Resource resource, Page page, HttpServletRequest request) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Validating POST request with form definition stored at {}.", (Object)resource.getPath());
        }
        com.day.cq.security.Authorizable authorizable = null;
        ResourceResolver resolver = page.adaptTo(Resource.class).getResourceResolver();
        Session s = resolver.adaptTo(Session.class);
        UserManager userManager = resolver.adaptTo(UserManager.class);
        AuthorizableLeadFormRequestProperties props = new AuthorizableLeadFormRequestProperties(LeadFormsCreator.getActionParameterMap(resource, request));
        Map<String, String[]> parameter = LeadFormsCreator.getActionParameterMap(resource, request);
        String userId = props.getUserID();
        if (StringUtils.isEmpty((String)userId)) {
            if (StringUtils.isEmpty((String)request.getParameter(EMAIL))) {
                throw new SlingException("UserId and email, both cannot be null or empty", new Exception());
            }
            userId = request.getParameter(EMAIL);
        }
        try {
            String groupName;
            String intermediatePath = props.getIntermediatePath();
            try {
                authorizable = userManager.get(userId);
            }
            catch (NoSuchAuthorizableException ex) {
                String password = props.getPassword();
                if (password == null) {
                    String pwdChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ123456789";
                    password = "";
                    for (int i = 0; i < 12; ++i) {
                        password = password + pwdChars.charAt((int)(Math.random() * (double)pwdChars.length()));
                    }
                }
                authorizable = userManager.createUser(userId, password, userId, intermediatePath);
            }
            String cat = LeadFormsCreator.getParameter(resource, request, CQ_AUTHORIZABLE_CATEGORY);
            if (cat != null) {
                authorizable.setProperty(CQ_AUTHORIZABLE_CATEGORY, cat);
            }
            if (authorizable.isUser() && (groupName = props.getGroupName()) != null) {
                com.day.cq.security.Authorizable groupNameAuthorizable = null;
                try {
                    groupNameAuthorizable = userManager.get(groupName);
                }
                catch (NoSuchAuthorizableException ex) {
                    this.logger.debug("groupName - " + groupName + " does not exist");
                }
                if (groupNameAuthorizable == null) {
                    groupNameAuthorizable = userManager.createGroup(groupName, groupName, intermediatePath);
                    if (cat != null) {
                        groupNameAuthorizable.setProperty(CQ_AUTHORIZABLE_CATEGORY, cat);
                    }
                    this.logger.debug("Create group {}", (Object)groupNameAuthorizable.getID());
                }
                ((Group)groupNameAuthorizable).addMember(authorizable);
                this.logger.debug("Added authorizable {} to group {}", (Object)authorizable.getID(), (Object)groupNameAuthorizable.getID());
            }
            Profile profile = authorizable.getProfile();
            this.setProfileProperties(profile, parameter);
            if (parameter.containsKey("useasemailid")) {
                profile.put(EMAIL, userId);
            }
            profile.save();
            try {
                s.save();
            }
            catch (RepositoryException e) {
                try {
                    s.refresh(false);
                }
                catch (RepositoryException e1) {
                    this.logger.error("Failed to revert pending changes", (Throwable)e);
                }
                throw new SlingException(e.getMessage(), e);
            }
        }
        catch (AccessDeniedException e) {
            throw new SlingException(e.getMessage(), e);
        }
    }

    public void redirectUrl(Page containingPage, String extension, String errorCode, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String redirectUrl = request.getParameter(":redirect");
        if (redirectUrl != null && !AuthUtil.isRedirectValid(request, redirectUrl)) {
            this.logger.error("Invalid redirect specified: ", (Object)redirectUrl);
            redirectUrl = containingPage.getPath() + "." + EXTENSION;
        }
        this.logger.info(containingPage.getContentResource().getResourceType());
        if (errorCode != null || redirectUrl == null) {
            request.getSession().setAttribute("errorCode", (Object)errorCode);
            redirectUrl = containingPage.getContentResource().isResourceType("geometrixx/components/newsletterpage") ? request.getContextPath() + containingPage.getPath() + ".emailclient" + extension : request.getContextPath() + containingPage.getPath() + extension;
        }
        response.sendRedirect(redirectUrl);
    }

    public void unSubscribe() {
    }

    private void setProfileProperties(Profile profile, Map<String, String[]> props) throws AccessDeniedException {
        for (String entry : props.keySet()) {
            if (entry.startsWith(":") || entry.startsWith("_") || entry.equals(CQ_AUTHORIZABLE_CATEGORY)) continue;
            String[] value = props.get(entry);
            if (value.length == 0) {
                profile.remove(entry);
                continue;
            }
            profile.put(entry, value[0]);
        }
    }

    @Deprecated
    public void unsubscribeUser(Resource resource, Page page, SlingHttpServletRequest slingRequest, HttpServletRequest request) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Validating POST request with form definition stored at {}.", (Object)resource.getPath());
        }
        com.day.cq.security.Authorizable authorizable = null;
        I18n i18n = new I18n(slingRequest.getResourceBundle(page.getLanguage(false)));
        ResourceResolver resolver = page.adaptTo(Resource.class).getResourceResolver();
        Session s = resolver.adaptTo(Session.class);
        UserManager userManager = resolver.adaptTo(UserManager.class);
        AuthorizableLeadFormRequestProperties props = new AuthorizableLeadFormRequestProperties(LeadFormsCreator.getActionParameterMap(resource, request));
        String userId = props.getUserID();
        if (StringUtils.isEmpty((String)userId)) {
            if (StringUtils.isEmpty((String)request.getParameter(EMAIL))) {
                throw new SlingException(i18n.get("UserId and email, both cannot be null or empty "), new Exception());
            }
            userId = request.getParameter(EMAIL);
        }
        try {
            try {
                authorizable = userManager.get(userId);
            }
            catch (NoSuchAuthorizableException ex) {
                throw new SlingException(i18n.get("User does not exist for id - {0}", null, userId), new Exception());
            }
            String cat = LeadFormsCreator.getParameter(resource, request, CQ_AUTHORIZABLE_CATEGORY);
            if (cat != null) {
                authorizable.setProperty(CQ_AUTHORIZABLE_CATEGORY, cat);
            }
            if (authorizable.isUser()) {
                String groupName = props.getGroupName();
                if (groupName != null) {
                    com.day.cq.security.Authorizable groupNameAuthorizable = null;
                    try {
                        groupNameAuthorizable = userManager.get(groupName);
                    }
                    catch (NoSuchAuthorizableException ex) {
                        throw new SlingException(i18n.get("Please provide valid subscription list. {0} is not valid. ", null, groupName), new Exception());
                    }
                    ((Group)groupNameAuthorizable).removeMember(authorizable);
                    this.logger.debug("Removed id {} from group {}", (Object)authorizable.getID(), (Object)groupNameAuthorizable.getID());
                } else {
                    throw new SlingException(i18n.get("Subscription list cannot be null"), new Exception());
                }
            }
            try {
                s.save();
            }
            catch (RepositoryException e) {
                try {
                    s.refresh(false);
                }
                catch (RepositoryException e1) {
                    this.logger.error("Failed to revert pending changes", (Throwable)e);
                }
                throw new SlingException(e.getMessage(), e);
            }
        }
        catch (AccessDeniedException e) {
            throw new SlingException(e.getMessage(), e);
        }
    }

    public String createPassword() {
        String pwdChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ123456789";
        String password = "";
        for (int i = 0; i < 12; ++i) {
            password = password + pwdChars.charAt((int)(Math.random() * (double)pwdChars.length()));
        }
        return password;
    }

    public void createAuthLead(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException, RepositoryException {
        Map params = request.getParameterMap();
        ResourceResolver resolver = request.getResourceResolver();
        Session session = resolver.adaptTo(Session.class);
        String authId = this.validateAndGetAuthId(params);
        org.apache.jackrabbit.api.security.user.UserManager userManager = request.getResourceResolver().adaptTo(org.apache.jackrabbit.api.security.user.UserManager.class);
        Authorizable userAuth = userManager.getAuthorizable(authId);
        if (userAuth == null) {
            this.createAuthorizable(request, authId, false);
            userAuth = userManager.getAuthorizable(authId);
            this.addProfileProperties(request, params, userAuth);
        }
        if (params.containsKey("groupName")) {
            String groupName = ((String[])params.get("groupName"))[0];
            if (groupName == null || groupName.trim().equals("")) {
                return;
            }
            Authorizable groupAuth = userManager.getAuthorizable(groupName);
            if (groupAuth == null) {
                this.createAuthorizable(request, authId, true);
            } else {
                ((org.apache.jackrabbit.api.security.user.Group)groupAuth).addMember(userAuth);
                session.save();
            }
        }
    }

    public void removeLeadFromGroup(SlingHttpServletRequest request) throws ServletException, IOException, RepositoryException {
        Map params = request.getParameterMap();
        String userId = this.validateAndGetAuthId(params);
        org.apache.jackrabbit.api.security.user.UserManager userManager = request.getResourceResolver().adaptTo(org.apache.jackrabbit.api.security.user.UserManager.class);
        if (!params.containsKey("groupName")) {
            throw new RuntimeException(ERR_02);
        }
        if ((String[])params.get("groupName") == null || ((String[])params.get("groupName"))[0].trim().equals("")) {
            throw new RuntimeException(ERR_02);
        }
        String groupName = ((String[])params.get("groupName"))[0];
        Authorizable groupAuth = userManager.getAuthorizable(groupName);
        Authorizable userAuth = userManager.getAuthorizable(userId);
        if (groupAuth == null || !groupAuth.isGroup()) {
            throw new RuntimeException(ERR_03);
        }
        if (userAuth == null) {
            throw new RuntimeException(ERR_04);
        }
        ((org.apache.jackrabbit.api.security.user.Group)groupAuth).removeMember(userAuth);
        Session session = request.getResourceResolver().adaptTo(Session.class);
        session.save();
    }

    private String validateAndGetAuthId(Map<String, Object> params) {
        Object value;
        if (params.containsKey(REP_USER_ID) && (value = params.get(REP_USER_ID)) != null && !((String[])value)[0].trim().equals("")) {
            return ((String[])params.get(REP_USER_ID))[0];
        }
        if (params.containsKey(EMAIL) && (value = params.get(EMAIL)) != null && !((String[])value)[0].trim().equals("")) {
            return ((String[])params.get(EMAIL))[0];
        }
        throw new SlingException(ERR_01, new Exception());
    }

    private void createAuthorizable(SlingHttpServletRequest request, String authId, boolean createGroup) throws ServletException, IOException, RepositoryException {
        Map params = request.getParameterMap();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(CQ_AUTHORIZABLE_CATEGORY, new String[]{MCM});
        if (!createGroup) {
            if (!params.containsKey("rep:password")) {
                parameters.put("rep:password", this.createPassword());
            }
            parameters.put(CREATE_USER, "");
            parameters.put(AUTHORIZABLE_ID, authId);
        } else {
            parameters.put(CREATE_GROUP, "");
            parameters.put(ADD_MEMBERS, authId);
            parameters.put(AUTHORIZABLE_ID, ((String[])params.get("groupName"))[0]);
        }
        HttpServletRequest req = this.requestResponseFactory.createRequest(request.getMethod(), LIBS_GRANITE_SECURITY_POST_AUTHORIZABLES, parameters);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        HttpServletResponse res = this.requestResponseFactory.createResponse(stream);
        this.slingRequestProcessor.processRequest(req, res, request.getResourceResolver());
        String htmlresponse = stream.toString();
        this.logger.debug(htmlresponse);
        if (htmlresponse.contains("Exception") || htmlresponse.contains("Error")) {
            int messageTagIndex = htmlresponse.indexOf("<div id=\"Message\">");
            String messageSubstring = htmlresponse.substring(messageTagIndex);
            int messageTagEndTagIndex = messageSubstring.indexOf("</div>");
            String errorMessage = messageSubstring.substring(0, messageTagEndTagIndex);
            throw new RuntimeException(errorMessage);
        }
    }

    private void addProfileProperties(SlingHttpServletRequest request, Map<String, Object> parameters, Authorizable auth) throws ServletException, IOException, RepositoryException {
        HashMap<String, Object> updateParameters = new HashMap<String, Object>();
        for (String key : parameters.keySet()) {
            if (RESERVED.contains(key)) continue;
            Object value = parameters.get(key);
            updateParameters.put(key, value);
        }
        updateParameters.put(PROFILE_PATH, "profile");
        HttpServletRequest req = this.requestResponseFactory.createRequest(request.getMethod(), auth.getPath() + ".userproperties.html", updateParameters);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        HttpServletResponse res = this.requestResponseFactory.createResponse(stream);
        this.slingRequestProcessor.processRequest(req, res, request.getResourceResolver());
        String htmlresponse = stream.toString();
        this.logger.debug(htmlresponse);
        if (htmlresponse.contains("Exception") || htmlresponse.contains("Error")) {
            int messageTagIndex = htmlresponse.indexOf("<div id=\"Message\">");
            String messageSubstring = htmlresponse.substring(messageTagIndex);
            int messageTagEndTagIndex = messageSubstring.indexOf("</div>");
            String errorMessage = messageSubstring.substring(0, messageTagEndTagIndex);
            throw new RuntimeException(errorMessage);
        }
    }

    static {
        RESERVED.add("groupName");
        RESERVED.add(AUTHORIZABLE_ID);
        RESERVED.add(CQ_AUTHORIZABLE_CATEGORY);
        RESERVED.add("rep:password");
        RESERVED.add(CREATE_USER);
        RESERVED.add(FORMSTART);
        RESERVED.add(PARAM_SUBMIT);
    }

    protected void bindRequestResponseFactory(RequestResponseFactory requestResponseFactory) {
        this.requestResponseFactory = requestResponseFactory;
    }

    protected void unbindRequestResponseFactory(RequestResponseFactory requestResponseFactory) {
        if (this.requestResponseFactory == requestResponseFactory) {
            this.requestResponseFactory = null;
        }
    }

    protected void bindSlingRequestProcessor(SlingRequestProcessor slingRequestProcessor) {
        this.slingRequestProcessor = slingRequestProcessor;
    }

    protected void unbindSlingRequestProcessor(SlingRequestProcessor slingRequestProcessor) {
        if (this.slingRequestProcessor == slingRequestProcessor) {
            this.slingRequestProcessor = null;
        }
    }
}

