/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.emailprovider.util;

import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.mailer.MessageTemplate;
import com.day.cq.mailer.commons.MailHelper;
import com.day.cq.mcm.api.newsletter.NewsLetter;
import com.day.cq.mcm.core.NewsletterHelper;
import com.day.cq.mcm.emailprovider.impl.types.EmailImpl;
import com.day.cq.mcm.emailprovider.types.Email;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.auth.core.AuthUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailHelper {
    private static final String EXTENSION_HTML = ".html";
    private static final String REDIRECT_PAGE_PARAMETER = ":redirect";
    private static final String CLOUD_CONFIG_PROPERTY_NAME = "cq:cloudserviceconfigs";
    private static final String SCRIPT_START_TAG = "<script";
    private static final String SCRIPT_END_TAG = "</script>";
    private static final String DEFAULT_CQ_NEWSLETTER_NAME = "CQ Newsletter";
    private static final Logger log = LoggerFactory.getLogger(EmailHelper.class);
    public static final String PN_PROVIDER_NAME = "providerName";
    public static final String PN_USERNAME = "username";
    public static final String PN_PASSWORD = "password";
    public static final String PN_ENDPOINT = "endpoint";
    public static final String PN_APIENDPOINT = "apiendpoint";
    public static final String PN_EMAIL = "email";
    public static final String PN_LISTID = "subscriptionlist";
    public static final String PN_AUTORESPONDER_EMAIL = "autoresponderemail";
    public static final String PN_EMAIL_CLASSIFICATION = "emailclassification";
    public static final String PN_ACCOUNTID = "accountId";

    public static String[] getConfig(SlingHttpServletRequest request) {
        Page page;
        RequestParameterMap map = request.getRequestParameterMap();
        String path = NewsletterHelper.getParameter(map, "newsletter");
        Resource resource = path != null ? request.getResourceResolver().resolve(path) : request.getResource();
        PageManager pmgr = request.getResourceResolver().adaptTo(PageManager.class);
        if (pmgr != null && (page = pmgr.getContainingPage(resource)) != null) {
            resource = page.adaptTo(Resource.class);
            HierarchyNodeInheritanceValueMap pageProperties = new HierarchyNodeInheritanceValueMap(page.getContentResource());
            return pageProperties.getInherited(CLOUD_CONFIG_PROPERTY_NAME, new String[0]);
        }
        return new String[0];
    }

    public static void redirectUrl(Boolean isError, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String redirectUrl = request.getParameter(REDIRECT_PAGE_PARAMETER);
        if (redirectUrl != null && !AuthUtil.isRedirectValid(request, redirectUrl)) {
            log.error("Invalid redirect specified: ", (Object)redirectUrl);
            redirectUrl = null;
        }
        Resource resource = request.getResource();
        PageManager pmgr = request.getResourceResolver().adaptTo(PageManager.class);
        Page page = null;
        if (pmgr != null) {
            page = pmgr.getContainingPage(resource);
        }
        if (isError.booleanValue() || redirectUrl == null) {
            if (page != null) {
                redirectUrl = request.getContextPath() + page.getPath() + EXTENSION_HTML;
            } else {
                return;
            }
        }
        response.sendRedirect(redirectUrl);
    }

    private static String getName(String name, NewsLetter newsletter) {
        if (name == null || name.trim().equals("")) {
            String path = newsletter.getPath();
            int index = path.lastIndexOf(47);
            if (index == -1) {
                index = path.lastIndexOf(92);
            }
            name = index == -1 ? DEFAULT_CQ_NEWSLETTER_NAME : path.substring(index + 1);
        }
        return name;
    }

    private static String convertMail(String html) {
        StringBuffer strBuf = new StringBuffer("");
        int startIndex = html.indexOf(SCRIPT_START_TAG);
        if (startIndex == -1) {
            return html;
        }
        int subStartIndex = 0;
        int subEndIndex = startIndex;
        do {
            strBuf.append(html.substring(subStartIndex, subEndIndex));
            int endIndex = html.indexOf(SCRIPT_END_TAG, startIndex);
            if (endIndex == -1) {
                log.debug("Invalid HTML, No matching script end tag.");
                return html;
            }
            startIndex = html.indexOf(SCRIPT_START_TAG, endIndex + SCRIPT_END_TAG.length());
            subStartIndex = endIndex + SCRIPT_END_TAG.length();
            subEndIndex = startIndex;
        } while (startIndex != -1);
        strBuf.append(html.substring(subStartIndex));
        return strBuf.toString();
    }

    private static String getHtml(MessageTemplate template) {
        String html = MailHelper.getHtml(template);
        return EmailHelper.convertMail(html);
    }

    public static Email getEmail(String name, NewsLetter letter) {
        EmailImpl email = new EmailImpl();
        email.setName(EmailHelper.getName(name, letter));
        String text = MailHelper.getText(letter.getMessageTemplate());
        if (StringUtils.isEmpty((String)text)) {
            email.setContent(EmailHelper.getHtml(letter.getMessageTemplate()));
            email.setHtml(true);
        } else {
            email.setContent(text);
            email.setHtml(false);
        }
        String subject = letter.getSubject();
        if (subject == null || subject.trim().equals("")) {
            subject = "No Subject";
        }
        email.setSubject(subject);
        return email;
    }
}

