/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.core;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.AssetReferenceSearch;
import com.day.cq.mcm.api.newsletter.NewsLetter;
import com.day.cq.mcm.api.newsletter.NewsletterEmailService;
import com.day.cq.mcm.api.newsletter.NewsletterService;
import com.day.cq.replication.ReplicationStatus;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterHelper {
    public static final String PARAM_NEWSLETTER = "newsletter";
    public static final String PARAM_RECIPIENTS = "letterRecipient";
    public static final String PARAM_TEST_TO = "testRecipient";
    public static final String PARAM_TEST_PROFILE = "testProfile";

    public static NewsLetter fromRequest(SlingHttpServletRequest request, NewsletterService service) throws RepositoryException {
        Page page;
        RequestParameterMap map = request.getRequestParameterMap();
        String path = NewsletterHelper.getParameter(map, PARAM_NEWSLETTER);
        Resource resource = path != null ? request.getResourceResolver().resolve(path) : request.getResource();
        NewsLetter news = null;
        PageManager pmgr = request.getResourceResolver().adaptTo(PageManager.class);
        if (pmgr != null && (page = pmgr.getContainingPage(resource)) != null) {
            news = service.buildNewsletter(page);
            resource = page.adaptTo(Resource.class);
        }
        if (news == null) {
            URI uri = null;
            try {
                uri = new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), request.getContextPath() + resource.getPath(), null, null);
            }
            catch (URISyntaxException ignore) {
                // empty catch block
            }
            news = service.buildNewsletter(resource, uri);
        }
        return news;
    }

    public static NewsLetter fromRequest(SlingHttpServletRequest request, NewsletterEmailService service) throws RepositoryException {
        Page page;
        RequestParameterMap map = request.getRequestParameterMap();
        String path = NewsletterHelper.getParameter(map, PARAM_NEWSLETTER);
        Resource resource = path != null ? request.getResourceResolver().resolve(path) : request.getResource();
        NewsLetter news = null;
        PageManager pmgr = request.getResourceResolver().adaptTo(PageManager.class);
        if (pmgr != null && (page = pmgr.getContainingPage(resource)) != null) {
            news = service.buildNewsletter(page);
            resource = page.adaptTo(Resource.class);
        }
        if (news == null) {
            URI uri = null;
            try {
                uri = new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), request.getContextPath() + resource.getPath(), null, null);
            }
            catch (URISyntaxException ignore) {
                // empty catch block
            }
            news = service.buildNewsletter(resource, uri);
        }
        return news;
    }

    public static Collection<Resource> getUnpublishedResources(NewsLetter letter, ResourceResolver resolver) throws RepositoryException {
        HashSet<Resource> set = new HashSet<Resource>();
        Resource resource = resolver.getResource(letter.getPath());
        if (resource != null) {
            Calendar lastMod;
            Page page = resource.adaptTo(Page.class);
            if (page != null) {
                lastMod = page.getLastModified();
            } else {
                ValueMap map = resource.adaptTo(ValueMap.class);
                lastMod = (Calendar)((Object)map.get("jcr:lastModified", Calendar.class));
            }
            if (lastMod != null && NewsletterHelper.needsReplication(resource, lastMod.getTimeInMillis())) {
                set.add(resource);
            }
            NewsletterHelper.addPublishAssets(resource.adaptTo(Node.class), resolver, set);
        }
        return Collections.unmodifiableSet(set);
    }

    public static boolean isPublishUptodate(NewsLetter letter, ResourceResolver resolver) {
        try {
            boolean unPublishedResources = NewsletterHelper.getUnpublishedResources(letter, resolver).size() > 0;
            Resource resource = resolver.resolve(letter.getPath());
            ReplicationStatus status = resource.adaptTo(ReplicationStatus.class);
            boolean delivered = status != null && status.isDelivered();
            return !unPublishedResources && delivered;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public static String getParameter(RequestParameterMap map, String key) {
        String val;
        if (map.containsKey(key) && !StringUtils.isBlank((String)(val = map.getValue(key).getString()))) {
            return val.trim();
        }
        return null;
    }

    private static HashSet<Resource> addPublishAssets(Node node, ResourceResolver resolver, HashSet<Resource> set) throws RepositoryException {
        AssetReferenceSearch search = new AssetReferenceSearch(node, "/content/dam", resolver);
        Map<String, Asset> refs = search.search();
        for (Asset asset : refs.values()) {
            Resource resource = asset.adaptTo(Resource.class);
            if (resource == null || !NewsletterHelper.needsReplication(resource, asset.getLastModified())) continue;
            set.add(resource);
        }
        return set;
    }

    private static boolean needsReplication(Resource resource, long lastModTimestamp) {
        ReplicationStatus replStatus = resource.adaptTo(ReplicationStatus.class);
        if (replStatus != null) {
            boolean needsReplication = !replStatus.isDelivered() || !replStatus.isActivated();
            return needsReplication || replStatus.getLastPublished().getTimeInMillis() < lastModTimestamp;
        }
        return false;
    }
}

