/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.core;

import com.adobe.granite.xss.XSSAPI;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.scripting.SlingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCMFormsHelper {
    private static final Logger log = LoggerFactory.getLogger((String)MCMFormsHelper.class.getName());
    private static final String FOUNDATION_FORM_START = "foundation/components/form/start";
    private static final String FOUNDATION_FORM_END = "foundation/components/form/end";
    private static final String CTA_EMAIL_ID = "mcm/components/cta-form/emailId";

    private MCMFormsHelper() {
    }

    private static Resource checkEmailExists(Resource formResource) {
        Resource resource = null;
        boolean found = false;
        try {
            Resource formParent = formResource.getParent();
            Iterator<Resource> iter = formParent.listChildren();
            Boolean start = false;
            while (iter.hasNext()) {
                resource = iter.next();
                if (start.booleanValue()) {
                    if (ResourceUtil.isA(resource, CTA_EMAIL_ID)) {
                        found = true;
                        break;
                    }
                    if (ResourceUtil.isA(resource, FOUNDATION_FORM_END)) {
                        found = true;
                        break;
                    }
                }
                if (start.booleanValue() || !resource.getName().equals(formResource.getName())) continue;
                start = true;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        if (found) {
            return resource;
        }
        return null;
    }

    public static Node addEmail(Resource formResource) {
        try {
            if (!ResourceUtil.isA(formResource, FOUNDATION_FORM_START)) {
                return null;
            }
            Resource resource = MCMFormsHelper.checkEmailExists(formResource);
            if (resource == null) {
                log.error("Form End not found");
                return null;
            }
            if (ResourceUtil.isA(resource, CTA_EMAIL_ID)) {
                return null;
            }
            Node orderBefore = resource.adaptTo(Node.class);
            Node formParent = orderBefore.getParent();
            int suffix = 0;
            while (formParent.hasNode("emailid_" + suffix)) {
                ++suffix;
            }
            String nodeName = formParent.hasNode("emailid") ? "emailid_" + suffix : "emailid";
            Node emailId = formParent.addNode(nodeName, "nt:unstructured");
            emailId.setProperty("name", "email");
            emailId.setProperty("sling:resourceType", CTA_EMAIL_ID);
            emailId.setProperty("sling:resourceSuperType", "foundation/components/form/defaults/field");
            emailId.setProperty("required", "true");
            emailId.setProperty("constraintType", "foundation/components/form/constraints/email");
            formParent.orderBefore(emailId.getName(), orderBefore.getName());
            formParent.getSession().save();
            return emailId;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static void printTitle(String fieldId, String title, boolean required, boolean hideLabel, String className, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        out.write("<div class=\"form_leftcol\"");
        if (hideLabel) {
            out.write(" style=\"display: none;\"");
        }
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        XSSAPI xssAPI = bindings.getSling().getService(XSSAPI.class).getRequestSpecificAPI(request);
        title = title != null && title.length() > 0 ? xssAPI.encodeForHTML(title) : "&nbsp;";
        out.write(">");
        String titileClassName = "form_leftcollabel" + (!StringUtils.isEmpty((String)className) ? " " + className : "");
        out.write("<div class=\"" + titileClassName + "\">");
        if (fieldId != null) {
            fieldId = xssAPI.encodeForHTMLAttr(fieldId);
            out.write("<label for=\"" + fieldId + "\">" + title + "</label>");
        } else {
            out.write("<span>" + title + "</span>");
        }
        out.write("</div>");
        out.write("<div class=\"form_leftcolmark\">");
        if (!hideLabel) {
            if (required) {
                out.write(" *");
            } else {
                out.write("&nbsp;");
            }
        }
        out.write("</div>");
        out.write("</div>\n");
    }
}

