/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mailer.commons;

import com.day.cq.mailer.MailingList;
import com.day.cq.security.Authorizable;
import com.day.cq.security.Group;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupMailingList
implements MailingList {
    private final Group group;
    private Predicate filterPredicate;

    public GroupMailingList(Group group) {
        this(group, null);
    }

    public GroupMailingList(Group group, Predicate filterPredicate) {
        this.group = group;
        this.filterPredicate = filterPredicate;
    }

    @Override
    public Iterator<Authorizable> members() throws RepositoryException {
        if (this.filterPredicate == null) {
            return new GroupUnfoldingIterator(this.group.members());
        }
        return IteratorUtils.filteredIterator((Iterator)new GroupUnfoldingIterator(this.group.members()), (Predicate)this.filterPredicate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GroupUnfoldingIterator
    implements Iterator<Authorizable> {
        private final Stack<Iterator<Authorizable>> iterators = new Stack();
        private final HashSet<String> served = new HashSet();
        private Authorizable next;

        GroupUnfoldingIterator(Iterator<Authorizable> base) {
            this.iterators.push(base);
            this.next = this.seek();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Authorizable next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Authorizable serve = this.next;
            this.next = this.seek();
            return serve;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Authorizable seek() {
            while (!this.iterators.isEmpty()) {
                Iterator<Authorizable> current = this.iterators.pop();
                while (current != null && current.hasNext()) {
                    Authorizable test = current.next();
                    if (this.served.contains(test.getID())) continue;
                    this.served.add(test.getID());
                    if (current.hasNext()) {
                        this.iterators.push(current);
                    }
                    if (!test.isUser()) {
                        this.iterators.push(((Group)test).members());
                    }
                    return test;
                }
            }
            return null;
        }
    }
}

