/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.graphics.chart;

import com.day.cq.graphics.Graph;
import com.day.cq.graphics.chart.Axis;
import com.day.cq.graphics.chart.Chart;
import com.day.cq.graphics.chart.Data;
import com.day.cq.graphics.chart.DataRow;
import com.day.image.Layer;

public class PieChart
extends Chart {
    int width;
    int height;
    double start;

    public static String getName() {
        return "pie";
    }

    public Layer draw(Graph graph, boolean doDraw) {
        int r;
        Layer l = graph.createLayer(doDraw, this.width, this.height);
        int mx = r = (this.width < this.height ? this.width : this.height) / 2;
        int my = r;
        double from = this.start;
        Data data = graph.getData();
        Axis yAxis = graph.getYAxis();
        int num = data.getNumrows();
        double sum = 0.0;
        for (int i = 0; i < num; ++i) {
            sum += data.getDataRow((int)i).samples[0];
        }
        int k = 0;
        int i = num - 1;
        while (i >= 0) {
            DataRow row = data.getDataRow(k);
            double percent = row.samples[0] / sum;
            yAxis.ticksample[k] = 100.0 * percent;
            if (doDraw) {
                l.setPaint(row.color);
                if (percent == 1.0) {
                    l.fillEllipse(mx, my, r, r);
                } else if (percent > 0.0) {
                    double extent = 360.0 * percent;
                    l.fillSector(mx, my, r, r, from, extent);
                    from += extent;
                }
            }
            --i;
            ++k;
        }
        yAxis.ticksample[num] = 0.0;
        yAxis.numticks = num + 1;
        return l;
    }

    public void setWidth(int width) {
        if (this.width == 0) {
            this.width = width;
        }
    }

    public void setHeight(int height) {
        if (this.height == 0) {
            this.height = height;
        }
    }

    public void setStart(double start) {
        if (this.start == 0.0) {
            this.start = start;
        }
    }
}

