/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.ps;

import com.adobe.granite.asset.api.AssetRelation;
import com.adobe.internal.pdftoolkit.core.util.Utility;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetReferenceResolver;
import com.day.cq.dam.api.FormatHandler;
import com.day.cq.dam.api.ProcessorException;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.metadata.ExtractedMetadata;
import com.day.cq.dam.commons.handler.DefaultFormatHandler;
import com.day.cq.dam.handler.standard.pdf.PdfHandler;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(inherit=true, metatype=false)
@Service
public class PostScriptHandler
extends PdfHandler {
    private static final Logger log = LoggerFactory.getLogger(PostScriptHandler.class);
    @Reference(policy=ReferencePolicy.STATIC)
    private AssetReferenceResolver childRefResolver;
    public static final String CONTENT_MIMETYPE = "application/postscript";
    public static final String XMP_MANIFEST_PATH = "jcr:content/metadata/xmpMM:Manifest";
    public static final String FILE_REFERENCE_PATH = "stMfs:reference";
    private static final int MAGIC_SIZE = 1024;
    protected BundleContext bundleContext;

    @Override
    public String[] getMimeTypes() {
        return new String[]{CONTENT_MIMETYPE};
    }

    protected void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
    }

    protected void deactivate(ComponentContext componentContext) {
        this.bundleContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ExtractedMetadata extractMetadata(Asset asset) {
        ExtractedMetadata metadata = new ExtractedMetadata();
        InputStream in = null;
        try {
            in = asset.getOriginal().getStream();
            metadata = this.extractMetadata(in, asset);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            IOUtils.closeQuietly((InputStream)in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        this.setMimetype(metadata, asset);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getImage(Rendition rendition, Dimension dim) throws IOException {
        BufferedImage bufferedImage;
        InputStream in = null;
        try {
            in = rendition.getStream();
            bufferedImage = this.getThumbnailImage(in, rendition, dim);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            IOUtils.closeQuietly((InputStream)in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return bufferedImage;
    }

    private ExtractedMetadata extractMetadata(InputStream in, Asset asset) {
        ExtractedMetadata metadata;
        block10: {
            metadata = new ExtractedMetadata();
            PushbackInputStream pin = new PushbackInputStream(in, 1024);
            byte[] data = new byte[1024];
            try {
                InputStream xmp;
                int len = pin.read(data);
                if (len <= 0) {
                    return metadata;
                }
                pin.unread(data, 0, len);
                if (this.isAIFile(data, 0, len)) {
                    try {
                        Node assetNode = asset.adaptTo(Node.class);
                        if (assetNode.hasNode(XMP_MANIFEST_PATH)) {
                            Node manifestNode = assetNode.getNode(XMP_MANIFEST_PATH);
                            manifestNode.remove();
                        }
                    }
                    catch (RepositoryException e) {
                        log.error("Error while deleting MANIFEST node of AI file", (Throwable)e);
                    }
                    return super.extractMetadata(asset);
                }
                FormatHandler handler = this.getHandler(data, 0, len);
                if (handler == null) {
                    handler = new DefaultFormatHandler();
                }
                if ((xmp = handler.getMetadata(pin)) != null) {
                    metadata.setXmp(xmp);
                }
            }
            catch (IOException e) {
                log.warn("I/O error while getting metadata.", (Throwable)e);
            }
            catch (ProcessorException e) {
                log.warn("Error while processing {}: {}", (Object)asset.getPath(), (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block10;
                log.debug("Stack trace.", (Throwable)e);
            }
        }
        return metadata;
    }

    protected BufferedImage getThumbnailImage(InputStream in, Rendition rendition, Dimension dim) {
        block6: {
            PushbackInputStream pin = new PushbackInputStream(in, 1024);
            byte[] data = new byte[1024];
            try {
                int len = pin.read(data);
                if (len <= 0) {
                    return null;
                }
                pin.unread(data, 0, len);
                if (this.isAIFile(data, 0, len)) {
                    return super.getImage(rendition, dim);
                }
                FormatHandler handler = this.getHandler(data, 0, len);
                if (handler == null) {
                    handler = new DefaultFormatHandler();
                }
                return handler.getThumbnailImage(pin);
            }
            catch (IOException e) {
                log.warn("I/O error while getting thumbnail image.", (Throwable)e);
            }
            catch (ProcessorException e) {
                log.warn("Error while processing {}: {}", (Object)rendition.getPath(), (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block6;
                log.debug("Stack trace.", (Throwable)e);
            }
        }
        return null;
    }

    private FormatHandler getHandler(byte[] data, int off, int len) {
        if (this.bundleContext == null) {
            log.warn("No bundle context available.");
            return null;
        }
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(FormatHandler.class.getName(), "(mimetype=*)");
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    FormatHandler handler = (FormatHandler)this.bundleContext.getService(ref);
                    if (handler.accepts(data, off, len)) {
                        return handler;
                    }
                    this.bundleContext.ungetService(ref);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            log.warn("Unexpected exception while getting all format handlers.", (Throwable)e);
        }
        return null;
    }

    private boolean isAIFile(byte[] data, int off, int len) {
        byte[] pdfMarker = new byte[]{37, 80, 68, 70, 45};
        int size = 1024;
        if (size > len) {
            size = len;
        }
        byte[] header = new byte[size];
        System.arraycopy(data, off, header, 0, size);
        long result = Utility.KMPFindFirst((byte[])pdfMarker, (int[])Utility.ComputeKMPNextArray((byte[])pdfMarker), (byte[])header);
        return result >= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> processSubAssets(Asset asset) {
        InputStream in = null;
        try {
            block6: {
                List<String> list;
                int len;
                byte[] data;
                PushbackInputStream pin;
                block5: {
                    in = asset.getOriginal().getStream();
                    pin = new PushbackInputStream(in, 1024);
                    data = new byte[1024];
                    len = pin.read(data);
                    if (len > 0) break block5;
                    List<String> list2 = null;
                    Object var8_9 = null;
                    IOUtils.closeQuietly((InputStream)in);
                    return list2;
                }
                try {
                    pin.unread(data, 0, len);
                    if (!this.isAIFile(data, 0, len)) break block6;
                    list = super.processSubAssets(asset);
                }
                catch (IOException e) {
                    log.warn("I/O error while getting processing subassets.", (Throwable)e);
                }
                Object var8_10 = null;
                IOUtils.closeQuietly((InputStream)in);
                return list;
            }
            Object var8_11 = null;
            IOUtils.closeQuietly((InputStream)in);
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            IOUtils.closeQuietly((InputStream)in);
            throw throwable;
        }
        log.debug("processSubAssets: no subassets to process for asset [{}].", (Object)asset.getPath());
        return new ArrayList<String>();
    }

    @Override
    public Iterator<? extends AssetRelation> processRelated(Asset asset) {
        return this.childRefResolver.resolve(asset);
    }

    protected void bindChildRefResolver(AssetReferenceResolver assetReferenceResolver) {
        this.childRefResolver = assetReferenceResolver;
    }

    protected void unbindChildRefResolver(AssetReferenceResolver assetReferenceResolver) {
        if (this.childRefResolver == assetReferenceResolver) {
            this.childRefResolver = null;
        }
    }
}

