/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.ooxml;

import com.adobe.granite.asset.api.AssetManager;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.handler.standard.ooxml.OpenOfficeHandler;
import com.day.image.Layer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(inherit=true, metatype=false)
@Service
public class MSPowerPointOOXMLHandler
extends OpenOfficeHandler {
    private static final String SUB_ASSET_PREFIX = "slide_";
    private static final String PPTX_EXT = ".pptx";
    private static final Logger log = LoggerFactory.getLogger(MSPowerPointOOXMLHandler.class);
    public static final String MIMETYPE_PPTX = "application/vnd.openxmlformats-officedocument.presentationml.presentation";

    @Override
    public boolean canHandleSubAssets() {
        return true;
    }

    @Override
    public String[] getMimeTypes() {
        return new String[]{MIMETYPE_PPTX};
    }

    private void removeSubAssets(Asset asset, AssetManager assetManager) {
        Collection<Asset> subAssets = asset.getSubAssets();
        for (Asset subAsset : subAssets) {
            assetManager.removeAsset(subAsset.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> processSubAssets(Asset asset) {
        ArrayList<String> subAssets = new ArrayList<String>();
        if (asset.isSubAsset()) {
            return subAssets;
        }
        InputStream is = null;
        try {
            try {
                is = asset.getOriginal().getStream();
                boolean oldBatchMode = asset.isBatchMode();
                asset.setBatchMode(true);
                AssetManager assetManager = asset.getOriginal().getResourceResolver().adaptTo(AssetManager.class);
                this.removeSubAssets(asset, assetManager);
                XMLSlideShow slideShow = new XMLSlideShow(is);
                for (int i = 0; i < slideShow.getSlides().length; ++i) {
                    Object var16_18;
                    int slideNumber = i + 1;
                    XMLSlideShow extractedSlide = this.extractSlide(asset, slideNumber);
                    FileOutputStream itout = null;
                    File pptTmpFile = null;
                    FileInputStream iis = null;
                    try {
                        try {
                            pptTmpFile = File.createTempFile("pptx", ".tmp");
                            itout = FileUtils.openOutputStream((File)pptTmpFile);
                            extractedSlide.write((OutputStream)itout);
                            String fileName = SUB_ASSET_PREFIX + slideNumber + PPTX_EXT;
                            iis = FileUtils.openInputStream((File)pptTmpFile);
                            Asset subAsset = asset.addSubAsset(fileName, asset.getMimeType(), iis);
                            subAssets.add(subAsset.getPath());
                        }
                        catch (IOException e) {
                            log.warn("error extracting subassets from asset {0} reason {1}", (Object)asset.getPath(), (Object)e.getMessage());
                            if (log.isDebugEnabled()) {
                                log.debug("Stack Trace", (Throwable)e);
                            }
                            var16_18 = null;
                            IOUtils.closeQuietly(iis);
                            IOUtils.closeQuietly((OutputStream)itout);
                            FileUtils.deleteQuietly((File)pptTmpFile);
                            continue;
                        }
                        var16_18 = null;
                    }
                    catch (Throwable throwable) {
                        var16_18 = null;
                        IOUtils.closeQuietly(iis);
                        IOUtils.closeQuietly((OutputStream)itout);
                        FileUtils.deleteQuietly((File)pptTmpFile);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)iis);
                    IOUtils.closeQuietly((OutputStream)itout);
                    FileUtils.deleteQuietly((File)pptTmpFile);
                }
                asset.adaptTo(Node.class).getSession().save();
                asset.setBatchMode(oldBatchMode);
            }
            catch (IOException e) {
                log.warn("error parsing asset {0} reason {1}", (Object)asset.getPath(), (Object)e.getMessage());
                if (log.isDebugEnabled()) {
                    log.debug("Stack Trace", (Throwable)e);
                }
                Object var18_21 = null;
                IOUtils.closeQuietly((InputStream)is);
                return subAssets;
            }
            catch (RepositoryException e) {
                log.warn("error parsing asset {0} reason {1}", (Object)asset.getPath(), (Object)e.getMessage());
                if (log.isDebugEnabled()) {
                    log.debug("Stack Trace", (Throwable)e);
                }
                Object var18_22 = null;
                IOUtils.closeQuietly((InputStream)is);
                return subAssets;
            }
            Object var18_20 = null;
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            IOUtils.closeQuietly((InputStream)is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return subAssets;
    }

    private XMLSlideShow extractSlide(Asset asset, int slideNumber) {
        XMLSlideShow slideShow;
        block4: {
            slideShow = null;
            try {
                int i;
                slideShow = new XMLSlideShow(asset.getOriginal().getStream());
                XSLFSlide[] slides = slideShow.getSlides();
                for (i = 0; i < slideNumber - 1; ++i) {
                    slideShow.removeSlide(0);
                }
                for (i = slideNumber; i < slides.length; ++i) {
                    slideShow.removeSlide(1);
                }
            }
            catch (IOException e) {
                log.warn("error extracting explicit slide from asset {0} reason {1}", (Object)asset.getPath(), (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block4;
                log.debug("Stack Trace", (Throwable)e);
            }
        }
        return slideShow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getImage(Rendition rendition, Dimension dim) throws IOException {
        InputStream is = rendition.getStream();
        XMLSlideShow slideShow = new XMLSlideShow(is);
        XSLFSlide[] slides = slideShow.getSlides();
        if (slides != null && slides.length > 0) {
            BufferedImage bufferedImage;
            dim = slideShow.getPageSize();
            try {
                BufferedImage image = new BufferedImage(dim.width, dim.height, 1);
                Graphics2D graphics = image.createGraphics();
                slides[0].draw(graphics);
                bufferedImage = new Layer(image).getImage();
                Object var10_10 = null;
            }
            catch (Exception e) {
                try {
                    log.warn("getImage: error while getting image for {} reason: {}", (Object)rendition.getPath(), (Object)e.getMessage());
                    if (log.isDebugEnabled()) {
                        log.debug("Stack Trace", (Throwable)e);
                    }
                    Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    IOUtils.closeQuietly((InputStream)is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                {
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return bufferedImage;
        }
        IOUtils.closeQuietly((InputStream)is);
        return null;
    }
}

