/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.msoffice;

import com.day.cq.dam.handler.standard.msoffice.IdToNameMap;
import com.day.cq.dam.handler.standard.msoffice.MSOfficeHandler;
import com.day.cq.dam.handler.standard.msoffice.MSOfficeMetadata;
import java.io.InputStream;
import org.apache.poi.hpsf.CustomProperty;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataReaderListener
implements POIFSReaderListener {
    private static final Logger log = LoggerFactory.getLogger(MSOfficeHandler.class);
    private MSOfficeMetadata metadata;
    private boolean debug;

    public MetaDataReaderListener() {
        if (log.isDebugEnabled()) {
            this.debug = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processPOIFSReaderEvent(POIFSReaderEvent event) {
        PropertySet ps;
        try {
            ps = PropertySetFactory.create((InputStream)event.getStream());
        }
        catch (NoPropertySetStreamException e) {
            log.warn("Failed to read metadata: {}", (Object)e.getMessage());
            if (!this.debug) return;
            log.debug("Failed to read metadata", (Throwable)e);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (ps.isDocumentSummaryInformation()) {
            DocumentSummaryInformation info = (DocumentSummaryInformation)ps;
            for (Property prop : info.getProperties()) {
                if (this.debug) {
                    log.debug("Setting document metadata property {} = {}", (Object)IdToNameMap.getDocumentPropertyName(prop.getID()), prop.getValue());
                }
                this.metadata.setProperty(IdToNameMap.getDocumentPropertyName(prop.getID()), prop.getValue(), prop.getType());
            }
            for (CustomProperty prop : info.getCustomProperties().values()) {
                if (this.debug) {
                    log.debug("Setting custom metadata property {} = {}", (Object)prop.getName(), prop.getValue());
                }
                this.metadata.setProperty(prop.getName(), prop.getValue(), prop.getType());
            }
            return;
        } else {
            if (!ps.isSummaryInformation()) return;
            try {
                SummaryInformation info = (SummaryInformation)ps;
                for (Property prop : info.getProperties()) {
                    if (this.debug) {
                        log.debug("Setting summary metadata property {} = {}", (Object)IdToNameMap.getSummaryPropertyName(prop.getID()), prop.getValue());
                    }
                    this.metadata.setProperty(IdToNameMap.getSummaryPropertyName(prop.getID()), prop.getValue(), prop.getType());
                }
                byte[] picture = info.getThumbnail();
                if (picture == null) return;
                this.metadata.setProperty("picture", picture);
                return;
            }
            catch (Exception e) {
                log.warn("Unable to get SummaryInformation: " + e.getMessage());
            }
        }
    }

    public void setMetadata(MSOfficeMetadata metadata) {
        this.metadata = metadata;
    }
}

