/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.standard.keynote;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementFilter
implements NodeFilter {
    private short defaultAction;
    private Map<String, Set<String>> skip;
    private Map<String, Set<String>> reject;
    private Map<String, Set<String>> accept;

    public ElementFilter(short defaultAction) {
        this.defaultAction = defaultAction;
        this.skip = new HashMap<String, Set<String>>();
        this.reject = new HashMap<String, Set<String>>();
        this.accept = new HashMap<String, Set<String>>();
    }

    private void add(Map<String, Set<String>> rule, String namespace, String localname) {
        if (rule.containsKey(namespace)) {
            rule.get(namespace).add(localname);
        } else {
            HashSet<String> ruleSet = new HashSet<String>();
            ruleSet.add(localname);
            rule.put(namespace, ruleSet);
        }
    }

    private boolean contains(Map<String, Set<String>> rule, String namespace, String localname) {
        return rule.containsKey(namespace) && rule.get(namespace).contains(localname);
    }

    private boolean accepted(String namespace, String localname) {
        return this.contains(this.accept, namespace, localname);
    }

    private boolean rejected(String namespace, String localname) {
        return this.contains(this.reject, namespace, localname);
    }

    private boolean skipped(String namespace, String localname) {
        return this.contains(this.skip, namespace, localname);
    }

    @Override
    public final short acceptNode(Node n) {
        if (n.getNodeType() == 1) {
            return this.acceptElement((Element)n);
        }
        return 2;
    }

    public final ElementFilter skipNodes(String namespace, String ... localnames) {
        for (String localname : localnames) {
            this.add(this.skip, namespace, localname);
        }
        return this;
    }

    public final ElementFilter rejectNodes(String namespace, String ... localnames) {
        for (String localname : localnames) {
            this.add(this.reject, namespace, localname);
        }
        return this;
    }

    public final ElementFilter acceptNodes(String namespace, String ... localnames) {
        for (String localname : localnames) {
            this.add(this.accept, namespace, localname);
        }
        return this;
    }

    public short acceptElement(Element e) {
        String localname;
        String namespace = e.getNamespaceURI();
        if (this.accepted(namespace, localname = e.getLocalName())) {
            return 1;
        }
        if (this.skipped(namespace, localname)) {
            return 3;
        }
        if (this.rejected(namespace, localname)) {
            return 2;
        }
        return this.defaultAction;
    }
}

