/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.core.process.SyncVarProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.Route;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Gate Keeper"})
public class GateKeeperProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(SyncVarProcess.class);

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        block9: {
            try {
                Asset asset = this.getAssetFromPayload(workItem, workflowSession.getSession());
                if (null != asset) {
                    Node assetNode = asset.adaptTo(Node.class);
                    if (asset.getOriginal().getSize() == 0L || assetNode.hasProperty("jcr:content/restored")) {
                        if (assetNode.hasProperty("jcr:content/restored")) {
                            assetNode.getNode("jcr:content").getProperty("restored").remove();
                            assetNode.getSession().save();
                            log.debug("It is a restored asset[{}], no processing needed. terminating workflow...", (Object)asset.getPath());
                        } else {
                            log.debug("File size is ZERO. terminating workflow...", (Object)asset.getPath());
                        }
                        workflowSession.terminateWorkflow(workItem.getWorkflow());
                        log.debug("execute: terminated workflow for asset [{}] .", (Object)asset.getPath());
                    } else {
                        boolean advanced = false;
                        List<Route> routes = workflowSession.getRoutes(workItem);
                        for (Route route : routes) {
                            if (!route.hasDefault()) continue;
                            workflowSession.complete(workItem, route);
                            advanced = true;
                        }
                        if (!advanced) {
                            workflowSession.complete(workItem, routes.get(0));
                        }
                    }
                    break block9;
                }
                String wfPayload = workItem.getWorkflowData().getPayload().toString();
                String message = "execute: gatekeeping failed, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
                throw new WorkflowException(message);
            }
            catch (RepositoryException e) {
                throw new WorkflowException(e);
            }
        }
    }
}

