/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.commons.Externalizer;
import com.day.cq.dam.api.jobs.AssetDownloadService;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service
@Properties(value={@Property(name="service.description", value={"Download selected asset(s)."}), @Property(name="process.label", value={"Download Dam Asset"})})
public class DownloadAssetProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(DownloadAssetProcess.class);
    private static final String DOWNLOADASSETS = "downloadAssets";
    private static final String DOWNLOADRENDITIONS = "downloadRenditions";
    private static final String DOWNLOADSUBASSETS = "downloadSubassets";
    private static final String S7EXPORTSETTINGS = "s7exportsettings";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    public AssetDownloadService assetDownloadService;

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        try {
            Session session = workflowSession.getSession();
            ResourceResolver rr = this.getResourceResolver(session);
            String payload = workItem.getWorkflowData().getPayload().toString();
            String srcPath = payload.split(".assetdownload.zip")[0];
            Resource resource = rr.getResource(srcPath);
            boolean downloadAssets = Boolean.parseBoolean(this.getValueFromPayload(DOWNLOADASSETS, payload));
            boolean downloadRenditions = Boolean.parseBoolean(this.getValueFromPayload(DOWNLOADRENDITIONS, payload));
            boolean downloadSubassets = Boolean.parseBoolean(this.getValueFromPayload(DOWNLOADSUBASSETS, payload));
            String s7exportsettings = this.getValueFromPayload(S7EXPORTSETTINGS, payload);
            String downloadName = this.getDownloadName(Text.unescape(payload.substring(0, payload.indexOf("?"))));
            ArrayList<String> paths = this.getAssetPath(payload);
            HashSet<Resource> downloadSet = new HashSet<Resource>();
            if (paths != null && paths.size() > 0) {
                for (String path : paths) {
                    Resource res = rr.getResource(path = URLDecoder.decode(path, "UTF-8"));
                    if (res == null) continue;
                    downloadSet.add(res);
                }
            } else {
                downloadSet.add(resource);
            }
            MetaDataMap wfMetaDataMap = workItem.getWorkflowData().getMetaDataMap();
            String emailRecipients = wfMetaDataMap.get("emailTo", new String());
            String downloadUrl = this.assetDownloadService.assetDownload(resource, downloadSet, downloadAssets, downloadRenditions, downloadSubassets, s7exportsettings, null, null, downloadName, emailRecipients);
            if (!StringUtils.isEmpty((String)downloadUrl)) {
                downloadUrl = System.getProperty("launchpad.http.server.url", this.getHostPrefix(rr)) + downloadUrl;
                wfMetaDataMap.put("downloadUrl", downloadUrl);
                metaData.put("downloadUrl", downloadUrl);
            } else {
                log.debug("downloadUrl is null or empty.");
            }
        }
        catch (Exception e) {
            log.error("execute: error while processing download asset; work item [{}]: ", (Object)workItem.getId(), (Object)e);
        }
    }

    private ArrayList<String> getAssetPath(String arg) {
        ArrayList<String> paths = new ArrayList<String>();
        int beginIdx = arg.indexOf("path=");
        while (beginIdx != -1) {
            int endIdx = arg.indexOf("&", beginIdx + 1);
            endIdx = endIdx == -1 ? arg.length() : endIdx;
            paths.add(arg.substring(beginIdx + "path+".length(), endIdx));
            beginIdx = arg.indexOf("path=", endIdx + 1);
        }
        return paths;
    }

    private String getValueFromPayload(String key, String argment) {
        String value = null;
        int beginIdx = argment.indexOf(key);
        if (beginIdx != -1 && this.validKeyParameter(key, argment.substring(beginIdx - 1, beginIdx + key.length() + 1))) {
            int endIdx = argment.indexOf("&", beginIdx);
            endIdx = endIdx == -1 ? argment.length() : endIdx;
            value = beginIdx == -1 ? "" : argment.substring(beginIdx + (key + "=").length(), endIdx);
        }
        return value;
    }

    private boolean validKeyParameter(String key, String argment) {
        boolean valid = false;
        List<String> params = Arrays.asList(argment.split("&|\\?|="));
        for (String param : params) {
            if (param.length() == 0) continue;
            valid = param.equals(key);
        }
        return valid;
    }

    private String getDownloadName(String pathInfo) {
        String name = pathInfo.substring(pathInfo.lastIndexOf("/") + 1, pathInfo.length());
        name = (name = name.replaceAll("[ :()*|]", "")).endsWith(".zip") ? name : name + ".zip";
        return name;
    }

    private String getHostPrefix(ResourceResolver resolver) {
        Externalizer externalizer = resolver.adaptTo(Externalizer.class);
        String externalizerHost = externalizer.externalLink(resolver, "local", "");
        if (externalizerHost != null && externalizerHost.endsWith("/")) {
            return externalizerHost.substring(0, externalizerHost.length() - 1);
        }
        return externalizerHost;
    }

    protected void bindAssetDownloadService(AssetDownloadService assetDownloadService) {
        this.assetDownloadService = assetDownloadService;
    }

    protected void unbindAssetDownloadService(AssetDownloadService assetDownloadService) {
        if (this.assetDownloadService == assetDownloadService) {
            this.assetDownloadService = null;
        }
    }
}

