/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.renditions.RenditionMaker;
import com.day.cq.dam.api.renditions.RenditionTemplate;
import com.day.cq.dam.api.thumbnail.ThumbnailConfig;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.commons.thumbnail.ThumbnailConfigImpl;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Property(name="process.label", value={"Create Thumbnail"})
public class CreateThumbnailProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(CreateThumbnailProcess.class);
    @Reference
    private RenditionMaker renditionMaker;

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        Asset asset = this.getAssetFromPayload(workItem, workflowSession.getSession());
        if (asset == null) {
            String wfPayload = workItem.getWorkflowData().getPayload().toString();
            String message = "execute: cannot create thumbnails, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
            throw new WorkflowException(message);
        }
        Config config = this.parseConfig(metaData);
        if (this.handleAsset(asset, config)) {
            asset.setBatchMode(true);
            RenditionTemplate[] templates = CreateThumbnailProcess.createRenditionTemplates(asset, config.thumbnails, this.renditionMaker);
            this.renditionMaker.generateRenditions(asset, templates);
        }
    }

    public static RenditionTemplate[] createRenditionTemplates(Asset asset, ThumbnailConfig[] thumbnails, RenditionMaker renditionMaker) {
        RenditionTemplate[] templates = new RenditionTemplate[thumbnails.length];
        for (int i = 0; i < thumbnails.length; ++i) {
            ThumbnailConfig thumb = thumbnails[i];
            templates[i] = renditionMaker.createThumbnailTemplate(asset, thumb.getWidth(), thumb.getHeight(), thumb.doCenter());
        }
        return templates;
    }

    public Config parseConfig(MetaDataMap metaData) {
        String[] args;
        String[] skipMimeTypeArgs;
        Config cfg = new Config();
        String processArgs = (String)((Object)metaData.get(Arguments.PROCESS_ARGS.name(), String.class));
        if (processArgs != null && !processArgs.equals("")) {
            String[] argTypes = processArgs.split(";");
            if (argTypes.length > 1) {
                skipMimeTypeArgs = argTypes[1].split(",");
                args = argTypes[0].split(",");
            } else {
                skipMimeTypeArgs = null;
                args = processArgs.split(",");
            }
        } else {
            String[] configs = (String[])metaData.get(Arguments.CONFIGS.name(), String[].class);
            skipMimeTypeArgs = (String[])metaData.get(Arguments.SKIP_MIME_TYPES.name(), String[].class);
            args = configs != null ? configs : new String[]{};
        }
        if (skipMimeTypeArgs != null) {
            List<String> values = this.getValuesFromArgs("skip", skipMimeTypeArgs);
            cfg.skipMimeTypes = values.toArray(new String[values.size()]);
        }
        cfg.thumbnails = CreateThumbnailProcess.parseThumbnailArguments(args);
        return cfg;
    }

    public static ThumbnailConfig[] parseThumbnailArguments(String[] args) {
        ArrayList<ThumbnailConfig> list = new ArrayList<ThumbnailConfig>();
        for (String arg : args) {
            ThumbnailConfig config = CreateThumbnailProcess.parseThumbnailArguments(arg);
            if (config == null) continue;
            list.add(config);
        }
        return list.toArray(new ThumbnailConfig[list.size()]);
    }

    public static ThumbnailConfig parseThumbnailArguments(String arg) {
        String str = arg.trim();
        if (str.contains("[") && (str = StringUtils.substringBetween((String)str, (String)"[", (String)"]")) == null) {
            log.warn("parseConfig: cannot parse width/height, missing closing bracket '{}'.", (Object)arg);
            return null;
        }
        String[] fragments = str.split(":");
        if (fragments.length >= 2) {
            try {
                Integer width = Integer.valueOf(fragments[0]);
                Integer height = Integer.valueOf(fragments[1]);
                boolean doCenter = false;
                if (fragments.length > 2) {
                    doCenter = Boolean.valueOf(fragments[2]);
                }
                return new ThumbnailConfigImpl(width, height, doCenter);
            }
            catch (NumberFormatException e) {
                log.warn("parseConfig: cannot parse, invalid width/height specified in config '{}': ", (Object)str, (Object)e);
                return null;
            }
        }
        log.warn("parseConfig: cannot parse, insufficient arguments in config '{}'.", (Object)str);
        return null;
    }

    protected boolean handleAsset(Asset asset, Config config) {
        if (asset == null || config.skipMimeTypes == null) {
            return true;
        }
        String mimeType = asset.getMimeType();
        if (mimeType == null) {
            return true;
        }
        for (String val : config.skipMimeTypes) {
            if (!mimeType.matches(val)) continue;
            log.debug(this.getClass().getName() + " skipped for MIME type: " + mimeType);
            return false;
        }
        return true;
    }

    protected void bindRenditionMaker(RenditionMaker renditionMaker) {
        this.renditionMaker = renditionMaker;
    }

    protected void unbindRenditionMaker(RenditionMaker renditionMaker) {
        if (this.renditionMaker == renditionMaker) {
            this.renditionMaker = null;
        }
    }

    public static class Config {
        public String[] skipMimeTypes;
        public ThumbnailConfig[] thumbnails;

        public Config() {
        }

        public Config(String[] skipMimeTypes, ThumbnailConfig[] thumbnails) {
            this.skipMimeTypes = skipMimeTypes;
            this.thumbnails = thumbnails;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Arguments {
        PROCESS_ARGS,
        CONFIGS,
        SKIP_MIME_TYPES;

    }
}

