/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Set Last Modified"})
public class AssetSetLastModifiedProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(AssetSetLastModifiedProcess.class);

    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        String[] args = this.buildArguments(metaData);
        Session session = workflowSession.getSession();
        Asset asset = this.getAssetFromPayload(workItem, session);
        if (null != asset) {
            try {
                List<String> relLastModifiedByPath;
                Rendition rendition;
                Node assetNode = asset.adaptTo(Node.class);
                String userId = (String)((Object)workItem.getWorkflowData().getMetaDataMap().get("userId", String.class));
                Node content = assetNode.getNode("jcr:content");
                Node metadata = assetNode.getNode("jcr:content/metadata");
                String resolvedUser = userId;
                String payloadPath = null;
                if (workItem.getWorkflowData().getPayloadType().equals("JCR_PATH")) {
                    payloadPath = workItem.getWorkflowData().getPayload().toString();
                }
                if (null != payloadPath) {
                    Node payloadNode = session.getNode(payloadPath);
                    Boolean enabled = true;
                    if (metadata != null && metadata.hasProperty("writebackEnable")) {
                        enabled = metadata.getProperty("writebackEnable").getBoolean();
                    }
                    if (payloadNode.hasProperty("newRendition") || !enabled.booleanValue()) {
                        return;
                    }
                }
                if (content.hasProperty("newRendition") && (rendition = asset.getRendition("original")) != null) {
                    String lastModified = (String)rendition.getProperties().get("jcr:lastModifiedBy");
                    if (StringUtils.isNotBlank((String)lastModified)) {
                        resolvedUser = lastModified;
                        content.setProperty("jcr:lastModifiedBy", resolvedUser);
                        content.setProperty("jcr:lastModified", Calendar.getInstance());
                    }
                    return;
                }
                List<String> relLastModifiedPath = this.getValuesFromArgs("relativeLastModifiedPath", args);
                if (relLastModifiedPath.size() > 0) {
                    String nodePath = Text.getRelativeParent(asset.getPath() + "/" + "jcr:content" + "/" + relLastModifiedPath.get(0), 1);
                    Node node = (Node)session.getItem(nodePath);
                    node.setProperty(Text.getName(relLastModifiedPath.get(0)), Calendar.getInstance());
                }
                if ((relLastModifiedByPath = this.getValuesFromArgs("relativeLastModifiedByPath", args)).size() > 0) {
                    String nodePath = Text.getRelativeParent(asset.getPath() + "/" + "jcr:content" + "/" + relLastModifiedByPath.get(0), 1);
                    Node node = (Node)session.getItem(nodePath);
                    node.setProperty(Text.getName(relLastModifiedByPath.get(0)), resolvedUser);
                }
                content.setProperty("jcr:lastModifiedBy", resolvedUser);
                content.setProperty("jcr:lastModified", Calendar.getInstance());
                String dcModifiedPath = "jcr:content/metadata/dc:modified";
                if (!assetNode.hasProperty(dcModifiedPath)) {
                    assetNode.getNode("jcr:content/metadata").setProperty("dc:modified", Calendar.getInstance());
                }
            }
            catch (RepositoryException e) {
                log.error("execute: repository error while setting last modified for asset [{}] in workflow [" + workItem.getId() + "]", (Object)asset.getPath(), (Object)e);
            }
        } else {
            String wfPayload = workItem.getWorkflowData().getPayload().toString();
            String message = "execute: cannot set last modified, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
            throw new WorkflowException(message);
        }
    }

    public String[] buildArguments(MetaDataMap metaData) {
        String processArgs = (String)((Object)metaData.get(Arguments.PROCESS_ARGS.name(), String.class));
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        String relativeLastModifiedPath = (String)((Object)metaData.get(Arguments.RELATIVE_LAST_MODIFIED_PATH.name(), String.class));
        String relativeLastModifiedByPath = (String)((Object)metaData.get(Arguments.RELATIVE_LAST_MODIFIED_BY_PATH.name(), String.class));
        if (StringUtils.isNotBlank((String)relativeLastModifiedPath)) {
            arguments.add(Arguments.RELATIVE_LAST_MODIFIED_PATH.getArgumentPrefix() + relativeLastModifiedPath);
        }
        if (StringUtils.isNotBlank((String)relativeLastModifiedByPath)) {
            arguments.add(Arguments.RELATIVE_LAST_MODIFIED_BY_PATH.getArgumentPrefix() + relativeLastModifiedByPath);
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Arguments {
        PROCESS_ARGS("PROCESS_ARGS"),
        RELATIVE_LAST_MODIFIED_PATH("relativeLastModifiedPath"),
        RELATIVE_LAST_MODIFIED_BY_PATH("relativeLastModifiedByPath");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public String getArgumentPrefix() {
            return this.argumentName + ":";
        }
    }
}

