/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.core.process.ApplyMetadataTemplateProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false)
@Service
@Property(name="process.label", value={"Apply Metadata Processing Profile"})
public class ApplyProcessingProfileProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(ApplyMetadataTemplateProcess.class);
    private static final String JCR_CONTENT_METADATA = "jcr:content/metadata";

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        try {
            Session session = workflowSession.getSession();
            Asset asset = this.getAssetFromPayload(workItem, session);
            String processingProfilePath = DamUtil.getAppliedProcessingProfilePath(asset);
            Resource resource = asset.adaptTo(Resource.class);
            ResourceResolver resolver = resource.getResourceResolver();
            Resource metadataResource = resolver.getResource(resource, JCR_CONTENT_METADATA);
            if (null != metadataResource) {
                ModifiableValueMap mvp = metadataResource.adaptTo(ModifiableValueMap.class);
                mvp.put("writebackEnable", true);
            }
            if (null != processingProfilePath && session.nodeExists(processingProfilePath) && session.nodeExists(processingProfilePath + "/" + "jcr:content")) {
                Node processingProfileContentNode = session.getNode(processingProfilePath + "/" + "jcr:content");
                if (null != processingProfileContentNode && processingProfileContentNode.hasProperty("metadataProfile")) {
                    String metadataProfilePath = processingProfileContentNode.getProperty("metadataProfile").getString();
                    this.applyMetadataProfile(session, asset, metadataProfilePath);
                }
            } else {
                Node assetNode;
                Node folderNode = null;
                Node iterNode = assetNode = asset.adaptTo(Node.class);
                while (!iterNode.getPath().equals("/content")) {
                    if ((iterNode = iterNode.getParent()).getPrimaryNodeType().getName().equals("dam:Asset") || !iterNode.hasNode(JCR_CONTENT_METADATA)) continue;
                    folderNode = iterNode;
                    break;
                }
                if (null != folderNode) {
                    if (!assetNode.hasNode(JCR_CONTENT_METADATA)) {
                        this.createAssetMetadataNode(assetNode);
                    }
                    this.copyProperties(folderNode.getNode(JCR_CONTENT_METADATA), assetNode);
                }
            }
        }
        catch (RepositoryException e) {
            log.warn("unexpected error occurred during metadata extraction. Cause: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private Node createAssetMetadataNode(Node assetNode) throws RepositoryException {
        Node _jcr_content = assetNode.hasNode("jcr:content") ? assetNode.getNode("jcr:content") : assetNode.addNode("jcr:content");
        return _jcr_content.addNode("metadata");
    }

    private void applyMetadataProfile(Session session, Asset asset, String path) throws RepositoryException {
        Node metadataProfileNode = session.getNode(path);
        Node assetNode = asset.adaptTo(Node.class);
        Node assetMetadataNode = assetNode.getNode(JCR_CONTENT_METADATA);
        if (null == metadataProfileNode) {
            return;
        }
        if (null == assetMetadataNode) {
            assetMetadataNode = this.createAssetMetadataNode(assetNode);
        }
        this.copyMetadataProfileValues(metadataProfileNode, assetNode);
        assetNode.getSession().save();
    }

    private void copyMetadataProfileValues(Node metadataProfileNode, Node assetNode) throws PathNotFoundException, RepositoryException {
        List<Node> formItems = this.getFormItems(metadataProfileNode);
        for (Node item : formItems) {
            javax.jcr.Property property;
            String mapsTo;
            if (!item.hasProperty("name") || (mapsTo = (property = item.getProperty("name")).getString()) == null || "".equals(mapsTo) || !item.hasProperty("value")) continue;
            javax.jcr.Property value = item.getProperty("value");
            mapsTo = mapsTo.substring(2);
            String relPathDataNode = mapsTo.substring(0, mapsTo.lastIndexOf("/") + 1);
            String propertyName = mapsTo.substring(mapsTo.lastIndexOf("/") + 1);
            Node dataNode = assetNode.getNode(relPathDataNode);
            if (dataNode.hasProperty(propertyName)) {
                ArrayList<Value> updatedVals;
                Value[] vals;
                javax.jcr.Property prop = dataNode.getProperty(propertyName);
                if (value.isMultiple() && prop.isMultiple()) {
                    vals = prop.getValues();
                    updatedVals = new ArrayList<Value>();
                    updatedVals.addAll(Arrays.asList(vals));
                    for (Value val : value.getValues()) {
                        if (updatedVals.contains(val)) continue;
                        updatedVals.add(val);
                    }
                    dataNode.setProperty(propertyName, updatedVals.toArray(new Value[updatedVals.size()]), prop.getType());
                    continue;
                }
                if (!value.isMultiple() && prop.isMultiple()) {
                    vals = prop.getValues();
                    updatedVals = new ArrayList();
                    updatedVals.addAll(Arrays.asList(vals));
                    if (!updatedVals.contains(value.getValue())) {
                        updatedVals.add(value.getValue());
                    }
                    dataNode.setProperty(propertyName, updatedVals.toArray(new Value[updatedVals.size()]), prop.getType());
                    continue;
                }
                if (value.isMultiple() && !prop.isMultiple()) {
                    dataNode.setProperty(propertyName, value.getValues(), prop.getType());
                    continue;
                }
                if (value.isMultiple() || prop.isMultiple()) continue;
                dataNode.setProperty(propertyName, value.getValue());
                continue;
            }
            if (!value.isMultiple()) {
                dataNode.setProperty(propertyName, value.getValue());
                continue;
            }
            dataNode.setProperty(propertyName, value.getValues(), value.getType());
        }
    }

    private void copyProperties(Node metadataProfileNode, Node assetMetadataNode) throws RepositoryException {
        PropertyIterator dpi = metadataProfileNode.getProperties();
        while (dpi.hasNext()) {
            javax.jcr.Property p = dpi.nextProperty();
            if (p.getName().startsWith("jcr:")) continue;
            if (assetMetadataNode.hasProperty(p.getName())) {
                ArrayList<Value> updatedVals;
                Value[] vals;
                javax.jcr.Property prop = assetMetadataNode.getProperty(p.getName());
                if (p.isMultiple() && prop.isMultiple()) {
                    vals = prop.getValues();
                    updatedVals = new ArrayList<Value>();
                    updatedVals.addAll(Arrays.asList(vals));
                    for (Value val : p.getValues()) {
                        if (updatedVals.contains(val)) continue;
                        updatedVals.add(val);
                    }
                    assetMetadataNode.setProperty(prop.getName(), updatedVals.toArray(new Value[updatedVals.size()]), prop.getType());
                    continue;
                }
                if (!p.isMultiple() && prop.isMultiple()) {
                    vals = prop.getValues();
                    updatedVals = new ArrayList();
                    updatedVals.addAll(Arrays.asList(vals));
                    if (!updatedVals.contains(p.getValue())) {
                        updatedVals.add(p.getValue());
                    }
                    assetMetadataNode.setProperty(prop.getName(), updatedVals.toArray(new Value[updatedVals.size()]), prop.getType());
                    continue;
                }
                if (p.isMultiple() || prop.isMultiple()) continue;
                assetMetadataNode.setProperty(p.getName(), p.getValue());
                continue;
            }
            if (!p.isMultiple()) {
                assetMetadataNode.setProperty(p.getName(), p.getValue());
                continue;
            }
            assetMetadataNode.setProperty(p.getName(), p.getValues(), p.getType());
        }
    }

    private List<Node> getFormItems(Node metadataProfileNode) throws PathNotFoundException, RepositoryException {
        ArrayList<Node> formItems = new ArrayList<Node>();
        NodeIterator iter = metadataProfileNode.getNode("items/tabs/items").getNodes();
        while (iter.hasNext()) {
            Node tab = iter.nextNode();
            if (!tab.hasNode("items")) continue;
            NodeIterator clmns = tab.getNode("items").getNodes();
            while (clmns.hasNext()) {
                Node clm = clmns.nextNode();
                if (!clm.hasNode("items")) continue;
                NodeIterator fields = clm.getNode("items").getNodes();
                while (fields.hasNext()) {
                    formItems.add(fields.nextNode());
                }
            }
        }
        return formItems;
    }
}

