/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.watermark;

import com.day.cq.dam.commons.watermark.ImageWatermark;
import com.day.cq.dam.commons.watermark.WatermarkContext;
import com.day.cq.dam.commons.watermark.WatermarkingException;
import com.day.image.Layer;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatermarkUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WatermarkUtil.class);
    private static final boolean _debug = true;

    public static void applyWatermark(WatermarkContext ctx) throws WatermarkingException {
        Layer layer = ctx.getImage();
        ImageWatermark watermark = (ImageWatermark)ctx.getWatermark();
        Layer wmLayer = new Layer(watermark.getImage());
        wmLayer.rotate(watermark.getOrientation());
        BufferedImage wmImage = wmLayer.getImage();
        watermark.setCoords(layer.getWidth(), layer.getHeight(), wmImage.getWidth(), wmImage.getHeight());
        LOG.info("Applying watermark to image with the following settings {}", (Object)watermark.toString());
        BufferedImage image = layer.getImage();
        Graphics2D graphics2D = image.createGraphics();
        AlphaComposite ac = AlphaComposite.getInstance(10, watermark.getOpacity());
        graphics2D.setComposite(ac);
        graphics2D.drawImage((Image)wmImage, watermark.getLeft(), watermark.getTop(), null);
        graphics2D.dispose();
        try {
            WatermarkUtil.saveLayer(new Layer(wmImage));
        }
        catch (IOException e) {
            throw new WatermarkingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveLayer(Layer layer) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(System.getProperty("java.io.tmpdir") + "wm.png");
            layer.write("image/png", 1.0, out);
            ((OutputStream)out).close();
            out = null;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }
}

